/*
 * Decompiled with CFR 0.152.
 */
package at.laborg.briss.utils;

import com.itextpdf.text.Rectangle;
import java.util.List;

public final class RectangleHandler {
    private RectangleHandler() {
    }

    public static Rectangle calculateScaledRectangle(List<Rectangle> list, Float[] floatArray, int n) {
        Rectangle rectangle3;
        if (floatArray == null || list.size() == 0) {
            return null;
        }
        Rectangle rectangle2 = null;
        float f = Float.MAX_VALUE;
        for (Rectangle rectangle3 : list) {
            if (rectangle3 == null) continue;
            if (rectangle2 == null) {
                rectangle2 = rectangle3;
            }
            if (!(f > rectangle3.getWidth() * rectangle3.getHeight())) continue;
            f = rectangle3.getWidth() * rectangle3.getHeight();
            rectangle2 = rectangle3;
        }
        if (rectangle2 == null) {
            return null;
        }
        Object object = RectangleHandler.rotateRatios(floatArray, n);
        rectangle3 = new Rectangle(rectangle2);
        rectangle3.setLeft(rectangle2.getLeft() + rectangle2.getWidth() * object[0]);
        rectangle3.setBottom(rectangle2.getBottom() + rectangle2.getHeight() * object[1]);
        rectangle3.setRight(rectangle2.getLeft() + rectangle2.getWidth() * (1.0f - object[2]));
        rectangle3.setTop(rectangle2.getBottom() + rectangle2.getHeight() * (1.0f - object[3]));
        return rectangle3;
    }

    private static float[] rotateRatios(Float[] floatArray, int n) {
        int n2;
        float[] fArray = new float[4];
        for (n2 = 0; n2 < 4; ++n2) {
            fArray[n2] = floatArray[n2].floatValue();
        }
        for (n2 = n; n2 > 0 && n2 < 360; n2 += 90) {
            float f = fArray[0];
            fArray[0] = fArray[1];
            fArray[1] = fArray[2];
            fArray[2] = fArray[3];
            fArray[3] = f;
        }
        return fArray;
    }
}

