/*
 * Decompiled with CFR 0.152.
 */
package at.laborg.briss.utils;

import java.text.ParseException;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PageNumberParser {
    private PageNumberParser() {
    }

    public static Set<Integer> parsePageNumber(String string) throws ParseException {
        Pattern pattern = Pattern.compile("[^0-9-;]");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            throw new ParseException("Allowed characters: \"0-9\" \";\" \"-\" ", 0);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        HashSet<Integer> hashSet = new HashSet<Integer>();
        while (stringTokenizer.hasMoreElements()) {
            hashSet.addAll(PageNumberParser.extractPageNumbers(stringTokenizer.nextToken()));
        }
        return hashSet;
    }

    private static Set<Integer> extractPageNumbers(String string) throws ParseException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
        HashSet<Integer> hashSet = new HashSet<Integer>();
        if (stringTokenizer.countTokens() == 1) {
            Integer n = Integer.parseInt(string);
            hashSet.add(n);
            return hashSet;
        }
        if (stringTokenizer.countTokens() == 2) {
            int n;
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            if (n2 > (n = Integer.parseInt(stringTokenizer.nextToken()))) {
                throw new ParseException("End must be bigger than start in \"" + string + "\"", 0);
            }
            for (int i = n2; i <= n; ++i) {
                hashSet.add(i);
            }
            return hashSet;
        }
        throw new ParseException("\"" + string + "\" has to many - characters!", 0);
    }
}

