/*
 * Decompiled with CFR 0.152.
 */
package at.laborg.briss.utils;

import at.laborg.briss.exception.CropException;
import at.laborg.briss.model.CropDefinition;
import at.laborg.briss.utils.BrissFileHandling;
import at.laborg.briss.utils.RectangleHandler;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDestination;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfImportedPage;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfSmartCopy;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.SimpleBookmark;
import com.itextpdf.text.pdf.SimpleNamedDestination;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;

public final class DocumentCropper {
    private DocumentCropper() {
    }

    public static File crop(CropDefinition cropDefinition) throws IOException, DocumentException, CropException {
        if (!BrissFileHandling.checkValidStateAndCreate(cropDefinition.getDestinationFile())) {
            throw new IOException("Destination file not valid");
        }
        if (DocumentCropper.isPasswordRequired(cropDefinition.getSourceFile())) {
            throw new CropException("Password required");
        }
        PdfMetaInformation pdfMetaInformation = new PdfMetaInformation(cropDefinition.getSourceFile());
        File file = DocumentCropper.copyToMultiplePages(cropDefinition, pdfMetaInformation);
        DocumentCropper.cropMultipliedFile(cropDefinition, file, pdfMetaInformation);
        return cropDefinition.getDestinationFile();
    }

    private static File copyToMultiplePages(CropDefinition cropDefinition, PdfMetaInformation pdfMetaInformation) throws IOException, DocumentException {
        Object object;
        StringTokenizer stringTokenizer;
        PdfReader pdfReader = new PdfReader(cropDefinition.getSourceFile().getAbsolutePath());
        HashMap hashMap = SimpleNamedDestination.getNamedDestination((PdfReader)pdfReader, (boolean)false);
        Document document = new Document();
        File file = File.createTempFile("cropped", ".pdf");
        PdfSmartCopy pdfSmartCopy = new PdfSmartCopy(document, (OutputStream)new FileOutputStream(file));
        document.open();
        HashMap<Integer, ArrayList<String>> hashMap2 = new HashMap<Integer, ArrayList<String>>();
        for (String string : hashMap.keySet()) {
            stringTokenizer = new StringTokenizer((String)hashMap.get(string), " ");
            if (!stringTokenizer.hasMoreElements()) continue;
            object = (String)stringTokenizer.nextElement();
            int n = Integer.parseInt((String)object);
            ArrayList<String> arrayList = (ArrayList<String>)hashMap2.get(n);
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
                arrayList.add(string);
                hashMap2.put(n, arrayList);
                continue;
            }
            arrayList.add(string);
        }
        int n = 0;
        for (int i = 1; i <= pdfMetaInformation.getSourcePageCount(); ++i) {
            Object object2;
            stringTokenizer = pdfSmartCopy.getImportedPage(pdfReader, i);
            pdfSmartCopy.addPage((PdfImportedPage)stringTokenizer);
            ++n;
            object = (List)hashMap2.get(i);
            if (object != null) {
                object2 = object.iterator();
                while (object2.hasNext()) {
                    String string = (String)object2.next();
                    pdfSmartCopy.addNamedDestination(string, n, new PdfDestination(1));
                }
            }
            object2 = cropDefinition.getRectanglesForPage(i);
            for (int j = 1; j < object2.size(); ++j) {
                pdfSmartCopy.addPage((PdfImportedPage)stringTokenizer);
                ++n;
            }
        }
        document.close();
        pdfSmartCopy.close();
        pdfReader.close();
        return file;
    }

    private static void cropMultipliedFile(CropDefinition cropDefinition, File file, PdfMetaInformation pdfMetaInformation) throws DocumentException, IOException {
        PdfReader pdfReader = new PdfReader(file.getAbsolutePath());
        PdfStamper pdfStamper = new PdfStamper(pdfReader, (OutputStream)new FileOutputStream(cropDefinition.getDestinationFile()));
        pdfStamper.setMoreInfo(pdfMetaInformation.getSourceMetaInfo());
        int n = 1;
        for (int i = 1; i <= pdfMetaInformation.getSourcePageCount(); ++i) {
            List<Float[]> list = cropDefinition.getRectanglesForPage(i);
            if (list.isEmpty()) {
                ++n;
                continue;
            }
            for (Float[] floatArray : list) {
                PdfDictionary pdfDictionary = pdfReader.getPageN(n);
                ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>();
                arrayList.add(pdfReader.getBoxSize(n, "media"));
                arrayList.add(pdfReader.getBoxSize(n, "crop"));
                int n2 = pdfReader.getPageRotation(n);
                Rectangle rectangle = RectangleHandler.calculateScaledRectangle(arrayList, floatArray, n2);
                PdfArray pdfArray = DocumentCropper.createScaledBoxArray(rectangle);
                pdfDictionary.put(PdfName.CROPBOX, (PdfObject)pdfArray);
                pdfDictionary.put(PdfName.MEDIABOX, (PdfObject)pdfArray);
                ++n;
            }
            Object object = new int[2];
            object[0] = n - 1;
            object[1] = pdfMetaInformation.getSourcePageCount() + (n - i);
            SimpleBookmark.shiftPageNumbers(pdfMetaInformation.getSourceBookmarks(), (int)(list.size() - 1), (int[])object);
        }
        pdfStamper.setOutlines(pdfMetaInformation.getSourceBookmarks());
        pdfStamper.close();
        pdfReader.close();
    }

    private static PdfArray createScaledBoxArray(Rectangle rectangle) {
        PdfArray pdfArray = new PdfArray();
        pdfArray.add((PdfObject)new PdfNumber(rectangle.getLeft()));
        pdfArray.add((PdfObject)new PdfNumber(rectangle.getBottom()));
        pdfArray.add((PdfObject)new PdfNumber(rectangle.getRight()));
        pdfArray.add((PdfObject)new PdfNumber(rectangle.getTop()));
        return pdfArray;
    }

    private static boolean isPasswordRequired(File file) throws IOException {
        PdfReader pdfReader = new PdfReader(file.getAbsolutePath());
        boolean bl = pdfReader.isEncrypted();
        pdfReader.close();
        return bl;
    }

    private static class PdfMetaInformation {
        private final int sourcePageCount;
        private final HashMap<String, String> sourceMetaInfo;
        private final List<HashMap<String, Object>> sourceBookmarks;

        public PdfMetaInformation(File file) throws IOException {
            PdfReader pdfReader = new PdfReader(file.getAbsolutePath());
            this.sourcePageCount = pdfReader.getNumberOfPages();
            this.sourceMetaInfo = pdfReader.getInfo();
            this.sourceBookmarks = SimpleBookmark.getBookmark((PdfReader)pdfReader);
            pdfReader.close();
        }

        public int getSourcePageCount() {
            return this.sourcePageCount;
        }

        public HashMap<String, String> getSourceMetaInfo() {
            return this.sourceMetaInfo;
        }

        public List<HashMap<String, Object>> getSourceBookmarks() {
            return this.sourceBookmarks;
        }
    }
}

