/*
 * Decompiled with CFR 0.152.
 */
package at.laborg.briss.utils;

import at.laborg.briss.model.ClusterDefinition;
import at.laborg.briss.model.PageCluster;
import java.awt.image.BufferedImage;
import java.io.File;
import org.jpedal.PdfDecoder;
import org.jpedal.exception.PdfException;

public class ClusterRenderWorker
extends Thread {
    public int workerUnitCounter = 1;
    private final File source;
    private final ClusterDefinition clusters;

    public ClusterRenderWorker(File file, ClusterDefinition clusterDefinition) {
        this.source = file;
        this.clusters = clusterDefinition;
    }

    @Override
    public final void run() {
        PdfDecoder pdfDecoder = new PdfDecoder();
        try {
            pdfDecoder.openPdfFile(this.source.getAbsolutePath());
        }
        catch (PdfException pdfException) {
            pdfException.printStackTrace();
        }
        for (PageCluster pageCluster : this.clusters.getClusterList()) {
            for (Integer n : pageCluster.getPagesToMerge()) {
                try {
                    if (!pageCluster.getImageData().isRenderable()) continue;
                    BufferedImage bufferedImage = pdfDecoder.getPageAsImage(n.intValue());
                    pageCluster.getImageData().addImageToPreview(bufferedImage);
                    ++this.workerUnitCounter;
                }
                catch (PdfException pdfException) {
                    pdfException.printStackTrace();
                }
            }
        }
        pdfDecoder.closePdfFile();
    }
}

