/*
 * Decompiled with CFR 0.152.
 */
package at.laborg.briss.utils;

import at.laborg.briss.model.ClusterDefinition;
import at.laborg.briss.model.PageCluster;
import at.laborg.briss.model.PageExcludes;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfReader;
import java.io.File;
import java.io.IOException;

public final class ClusterCreator {
    private ClusterCreator() {
    }

    public static ClusterDefinition clusterPages(File file, PageExcludes pageExcludes) throws IOException {
        PdfReader pdfReader = new PdfReader(file.getAbsolutePath());
        ClusterDefinition clusterDefinition = new ClusterDefinition();
        for (int i = 1; i <= pdfReader.getNumberOfPages(); ++i) {
            Rectangle rectangle = ClusterCreator.getLayoutBox(pdfReader, i);
            boolean bl = ClusterCreator.checkExclusionAndGetPageNumber(pageExcludes, i);
            PageCluster pageCluster = new PageCluster(i % 2 == 0, (int)rectangle.getWidth(), (int)rectangle.getHeight(), bl, i);
            clusterDefinition.addOrMergeCluster(pageCluster);
        }
        pdfReader.close();
        clusterDefinition.selectAndSetPagesForMerging();
        return clusterDefinition;
    }

    private static Rectangle getLayoutBox(PdfReader pdfReader, int n) {
        Rectangle rectangle = pdfReader.getBoxSize(n, "crop");
        if (rectangle == null) {
            rectangle = pdfReader.getBoxSize(n, "media");
        }
        return rectangle;
    }

    private static boolean checkExclusionAndGetPageNumber(PageExcludes pageExcludes, int n) {
        return pageExcludes != null && pageExcludes.containsPage(n);
    }
}

