/*
 * Decompiled with CFR 0.152.
 */
package at.laborg.briss.model;

import at.laborg.briss.model.ClusterImageData;
import java.util.ArrayList;
import java.util.List;

public class SingleCluster
implements Comparable<SingleCluster> {
    private static final int MERGE_VARIABILITY = 20;
    private static final int MAX_MERGE_PAGES = 20;
    private List<Integer> pagesToMerge;
    private List<Integer> allPages;
    private final List<Float[]> cropRatiosList = new ArrayList<Float[]>();
    private ClusterImageData imageData;
    private int excludedPageNumber = -1;
    private final boolean evenPage;
    private final int pageWidth;
    private final int pageHeight;

    public SingleCluster(boolean bl, int n, int n2, int n3) {
        this.pageWidth = n;
        this.pageHeight = n2;
        this.evenPage = bl;
        this.excludedPageNumber = n3;
        this.pagesToMerge = new ArrayList<Integer>();
    }

    public ClusterImageData getImageData() {
        if (this.imageData == null) {
            this.imageData = new ClusterImageData(this.pageWidth, this.pageHeight, this.pagesToMerge.size());
        }
        return this.imageData;
    }

    public List<Float[]> getRatiosList() {
        return this.cropRatiosList;
    }

    public void clearRatios() {
        this.cropRatiosList.clear();
    }

    public void addRatios(Float[] floatArray) {
        if (!this.cropRatiosList.contains(floatArray)) {
            this.cropRatiosList.add(floatArray);
        }
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.evenPage ? 1231 : 1237);
        n = 31 * n + this.excludedPageNumber;
        n = 31 * n + this.getRoundedPageHeight();
        n = 31 * n + this.getRoundedPageWidth();
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SingleCluster singleCluster = (SingleCluster)object;
        if (this.evenPage != singleCluster.evenPage) {
            return false;
        }
        if (this.excludedPageNumber != singleCluster.excludedPageNumber) {
            return false;
        }
        if (this.getRoundedPageHeight() != singleCluster.getRoundedPageHeight()) {
            return false;
        }
        return this.getRoundedPageWidth() == singleCluster.getRoundedPageWidth();
    }

    public boolean isEvenPage() {
        return this.evenPage;
    }

    public int getRoundedPageHeight() {
        int n = this.pageHeight / 20;
        return n * 20;
    }

    public int getRoundedPageWidth() {
        int n = this.pageWidth / 20;
        return n * 20;
    }

    public void choosePagesToMerge(List<Integer> list) {
        this.allPages = list;
        if (list.size() < 20) {
            this.pagesToMerge = list;
        } else {
            float f = (float)list.size() / 20.0f;
            float f2 = 0.0f;
            for (int i = 0; i < 20; ++i) {
                this.pagesToMerge.add(list.get(new Double(Math.floor(f2)).intValue()));
                f2 += f;
            }
        }
    }

    public List<Integer> getAllPages() {
        return this.allPages;
    }

    public List<Integer> getPagesToMerge() {
        return this.pagesToMerge;
    }

    @Override
    public int compareTo(SingleCluster singleCluster) {
        return this.getFirstPage() - singleCluster.getFirstPage();
    }

    private int getFirstPage() {
        int n = Integer.MAX_VALUE;
        for (Integer n2 : this.allPages) {
            if (n2 >= n) continue;
            n = n2;
        }
        return n;
    }
}

