/*
 * Decompiled with CFR 0.152.
 */
package at.laborg.briss.model;

import at.laborg.briss.model.ClusterImageData;
import java.util.ArrayList;
import java.util.List;

public class PageCluster
implements Comparable<PageCluster> {
    private static final int MERGE_VARIABILITY = 20;
    private static final int MAX_MERGE_PAGES = 15;
    private List<Integer> pagesToMerge;
    private final List<Integer> allPages;
    private final List<Float[]> cropRatiosList = new ArrayList<Float[]>();
    private boolean excluded = false;
    private ClusterImageData imageData;
    private final boolean evenPage;
    private final int pageWidth;
    private final int pageHeight;

    public PageCluster(boolean bl, int n, int n2, boolean bl2, int n3) {
        this.pageWidth = n;
        this.pageHeight = n2;
        this.evenPage = bl;
        this.excluded = bl2;
        this.pagesToMerge = new ArrayList<Integer>();
        this.allPages = new ArrayList<Integer>();
        this.allPages.add(n3);
    }

    public final ClusterImageData getImageData() {
        if (this.imageData == null) {
            this.imageData = new ClusterImageData(this.pageWidth, this.pageHeight, this.pagesToMerge.size());
        }
        return this.imageData;
    }

    public final List<Float[]> getRatiosList() {
        return this.cropRatiosList;
    }

    public final void clearRatios() {
        this.cropRatiosList.clear();
    }

    public final void addRatios(Float[] floatArray) {
        if (!this.cropRatiosList.contains(floatArray)) {
            this.cropRatiosList.add(floatArray);
        }
    }

    public final boolean isClusterNearlyEqual(PageCluster pageCluster) {
        return true;
    }

    public final void mergeClusters(PageCluster pageCluster) {
        this.allPages.addAll(pageCluster.getAllPages());
    }

    public final boolean isEvenPage() {
        return this.evenPage;
    }

    public final int getRoundedPageHeight() {
        int n = this.pageHeight / 20;
        return n * 20;
    }

    public final int getRoundedPageWidth() {
        int n = this.pageWidth / 20;
        return n * 20;
    }

    public final void choosePagesToMerge() {
        if (this.allPages.size() < 15) {
            this.pagesToMerge = this.allPages;
        } else {
            float f = (float)this.allPages.size() / 15.0f;
            float f2 = 0.0f;
            for (int i = 0; i < 15; ++i) {
                this.pagesToMerge.add(this.allPages.get(new Double(Math.floor(f2)).intValue()));
                f2 += f;
            }
        }
    }

    public final List<Integer> getAllPages() {
        return this.allPages;
    }

    public final List<Integer> getPagesToMerge() {
        return this.pagesToMerge;
    }

    @Override
    public final int compareTo(PageCluster pageCluster) {
        return this.getFirstPage() - pageCluster.getFirstPage();
    }

    private int getFirstPage() {
        int n = Integer.MAX_VALUE;
        for (Integer n2 : this.allPages) {
            if (n2 >= n) continue;
            n = n2;
        }
        return n;
    }
}

