/*
 * Decompiled with CFR 0.152.
 */
package at.laborg.briss.model;

import at.laborg.briss.model.ClusterCollection;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

public class CropJob {
    private final File source;
    private final int sourcePageCount;
    private final HashMap<String, String> sourceMetaInfo;
    private final List<HashMap<String, Object>> sourceBookmarks;
    private File destinationFile;
    private ClusterCollection clusterCollection;
    private static final String RECOMMENDED_ENDING = ".pdf";

    public CropJob(File file, int n, HashMap<String, String> hashMap, List<HashMap<String, Object>> list) {
        this.source = file;
        this.sourcePageCount = n;
        this.sourceMetaInfo = hashMap;
        this.sourceBookmarks = list;
    }

    public HashMap<String, String> getSourceMetaInfo() {
        return this.sourceMetaInfo;
    }

    public List<HashMap<String, Object>> getSourceBookmarks() {
        return this.sourceBookmarks;
    }

    public File getSource() {
        return this.source;
    }

    public int getSourcePageCount() {
        return this.sourcePageCount;
    }

    public File getDestinationFile() {
        return this.destinationFile;
    }

    public void setAndCreateDestinationFile(File file) throws IOException {
        if (!file.exists()) {
            file.createNewFile();
        }
        this.destinationFile = file;
    }

    public File getRecommendedDestination() {
        String string = this.getSource().getAbsolutePath();
        String string2 = string.substring(0, string.length() - 4) + RECOMMENDED_ENDING;
        return new File(string2);
    }

    public ClusterCollection getClusterCollection() {
        return this.clusterCollection;
    }

    public void setClusterCollection(ClusterCollection clusterCollection) {
        this.clusterCollection = clusterCollection;
    }
}

