/*
 * Decompiled with CFR 0.152.
 */
package at.laborg.briss.model;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;

public final class CropFinder {
    private static final double RATIO_LOOK_AHEAD_SATISFY = 0.85;
    private static final int LOOK_AHEAD_PIXEL_NR = 30;
    private static final int SD_CALC_SIZE_NR = 5;
    private static final float SD_THRESHOLD_TO_BE_COUNTED = 0.2f;
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int ORIENTATION_LEFT = 0;
    public static final int ORIENTATION_TOP = 1;
    public static final int ORIENTATION_RIGHT = 2;
    public static final int ORIENTATION_BOTTOM = 3;

    private CropFinder() {
    }

    public static Float[] getAutoCropFloats(BufferedImage bufferedImage) {
        WritableRaster writableRaster = bufferedImage.getRaster();
        double[] dArray = CropFinder.sumFrom2dTo1d(writableRaster, 0);
        double[] dArray2 = CropFinder.sumFrom2dTo1d(writableRaster, 1);
        double[] dArray3 = CropFinder.createDerivation(dArray);
        double[] dArray4 = CropFinder.createDerivation(dArray2);
        double[] dArray5 = CropFinder.createSdOfDerivation(dArray3);
        double[] dArray6 = CropFinder.createSdOfDerivation(dArray4);
        int n = CropFinder.findPosition(dArray5, 0);
        int n2 = CropFinder.findPosition(dArray6, 1);
        int n3 = CropFinder.findPosition(dArray5, 2);
        int n4 = CropFinder.findPosition(dArray6, 3);
        Float[] floatArray = new Float[]{Float.valueOf((float)n / (float)bufferedImage.getWidth()), Float.valueOf((float)(bufferedImage.getHeight() - n4) / (float)bufferedImage.getHeight()), Float.valueOf((float)(bufferedImage.getWidth() - n3) / (float)bufferedImage.getWidth()), Float.valueOf((float)n2 / (float)bufferedImage.getHeight())};
        return floatArray;
    }

    private static double[] sumFrom2dTo1d(WritableRaster writableRaster, int n) {
        if (n == 0) {
            double[] dArray = new double[writableRaster.getWidth()];
            int n2 = 0;
            while (n2 < writableRaster.getWidth()) {
                int[] nArray = null;
                for (int n3 : nArray = writableRaster.getPixels(n2, 0, 1, writableRaster.getHeight(), nArray)) {
                    int n4 = n2;
                    dArray[n4] = dArray[n4] + (double)n3;
                }
                int n5 = n2++;
                dArray[n5] = dArray[n5] / (double)writableRaster.getHeight();
            }
            return dArray;
        }
        if (n == 1) {
            double[] dArray = new double[writableRaster.getHeight()];
            int n6 = 0;
            while (n6 < writableRaster.getHeight()) {
                int[] nArray = null;
                for (int n7 : nArray = writableRaster.getPixels(0, n6, writableRaster.getWidth(), 1, nArray)) {
                    int n8 = n6;
                    dArray[n8] = dArray[n8] + (double)n7;
                }
                int n9 = n6++;
                dArray[n9] = dArray[n9] / (double)writableRaster.getWidth();
            }
            return dArray;
        }
        return null;
    }

    private static double[] createDerivation(double[] dArray) {
        double[] dArray2 = new double[dArray.length - 1];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = dArray[i + 1] - dArray[i];
        }
        return dArray2;
    }

    private static int findPosition(double[] dArray, int n) {
        int n2 = 0;
        block0 : switch (n) {
            case 1: {
                for (int i = 0; i < dArray.length - 30; ++i) {
                    int n3 = CropFinder.diffCounter(dArray, i, i + 30);
                    if (!((double)n3 > 25.5)) continue;
                    n2 = i;
                    break block0;
                }
                break;
            }
            case 0: {
                for (int i = 0; i < dArray.length - 30; ++i) {
                    int n4 = CropFinder.diffCounter(dArray, i, i + 30);
                    if (!((double)n4 > 25.5)) continue;
                    n2 = i;
                    break block0;
                }
                break;
            }
            case 3: {
                for (int i = dArray.length - 1; i >= 30; --i) {
                    int n5 = CropFinder.diffCounter(dArray, i - 30, i);
                    if (!((double)n5 > 25.5)) continue;
                    n2 = i;
                    break block0;
                }
                break;
            }
            case 2: {
                for (int i = dArray.length - 1; i >= 30; --i) {
                    int n6 = CropFinder.diffCounter(dArray, i - 30, i);
                    if (!((double)n6 > 25.5)) continue;
                    n2 = i;
                    break block0;
                }
                break;
            }
        }
        return n2;
    }

    private static double[] createSdOfDerivation(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            double[] dArray3 = new double[5];
            for (int j = 0; j < dArray3.length; ++j) {
                dArray3[j] = i + j < dArray.length ? dArray[i + j] : 0.0;
            }
            dArray2[i] = CropFinder.sd(dArray3);
        }
        return dArray2;
    }

    private static int diffCounter(double[] dArray, int n, int n2) {
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            if (!(dArray[i] > (double)0.2f)) continue;
            ++n3;
        }
        return n3;
    }

    private static double sd(double[] dArray) {
        double d = 0.0;
        double d2 = 0.0;
        for (double d3 : dArray) {
            d2 += d3;
        }
        d = d2 / (double)dArray.length;
        double d4 = 0.0;
        for (double d5 : dArray) {
            d4 += (d5 - d) * (d5 - d);
        }
        d4 = Math.sqrt(d4 / (double)dArray.length);
        return d4;
    }
}

