/*
 * Decompiled with CFR 0.152.
 */
package at.laborg.briss.model;

import at.laborg.briss.model.ClusterDefinition;
import at.laborg.briss.model.PageCluster;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class CropDefinition {
    private final File sourceFile;
    private final File destinationFile;
    private final Map<Integer, List<Float[]>> pageToCropRectangles;

    private CropDefinition(File file, File file2, HashMap<Integer, List<Float[]>> hashMap) {
        this.sourceFile = file;
        this.destinationFile = file2;
        this.pageToCropRectangles = hashMap;
    }

    public static CropDefinition createCropDefinition(File file, File file2, ClusterDefinition clusterDefinition) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Source must be provided");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("Source(" + file.getAbsolutePath() + ") file doesn't exist");
        }
        HashMap<Integer, List<Float[]>> hashMap = new HashMap<Integer, List<Float[]>>();
        for (PageCluster pageCluster : clusterDefinition.getClusterList()) {
            for (Integer n : pageCluster.getAllPages()) {
                List<Float[]> list = hashMap.get(n);
                if (list == null) {
                    list = new ArrayList<Float[]>();
                }
                list.addAll(pageCluster.getRatiosList());
                hashMap.put(n, list);
            }
        }
        CropDefinition cropDefinition = new CropDefinition(file, file2, hashMap);
        return cropDefinition;
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public File getDestinationFile() {
        return this.destinationFile;
    }

    public List<Float[]> getRectanglesForPage(Integer n) {
        if (this.pageToCropRectangles.containsKey(n)) {
            return this.pageToCropRectangles.get(n);
        }
        return Collections.emptyList();
    }
}

