/*
 * Decompiled with CFR 0.152.
 */
package at.laborg.briss.model;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;

public class ClusterImageData {
    private static final int MAX_PAGE_HEIGHT = 900;
    private static final int MAX_IMAGE_RENDER_SIZE = 4000000;
    private final boolean renderable;
    private BufferedImage outputImage = null;
    private int outputImageHeight = -1;
    private int outputImageWidth = -1;
    private short[][][] imgdata;
    private int imageCnt = 0;
    private final int totalImages;

    public ClusterImageData(int n, int n2, int n3) {
        this.renderable = n * n2 < 4000000;
        this.totalImages = n3;
    }

    public final boolean isRenderable() {
        return this.renderable;
    }

    public final void addImageToPreview(BufferedImage bufferedImage) {
        if (!this.renderable) {
            return;
        }
        if (this.outputImageHeight == -1) {
            this.initializeOutputImage(bufferedImage);
        }
        this.add(ClusterImageData.scaleImage(bufferedImage, this.outputImageWidth, this.outputImageHeight));
    }

    private void initializeOutputImage(BufferedImage bufferedImage) {
        this.outputImageHeight = bufferedImage.getHeight() > 900 ? 900 : bufferedImage.getHeight();
        float f = (float)this.outputImageHeight / (float)bufferedImage.getHeight();
        this.outputImageWidth = (int)((float)bufferedImage.getWidth() * f);
        this.imgdata = new short[this.outputImageWidth][this.outputImageHeight][this.totalImages];
    }

    private void add(BufferedImage bufferedImage) {
        int[] nArray = null;
        int n = bufferedImage.getHeight();
        int n2 = bufferedImage.getWidth();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                this.imgdata[i][j][this.imageCnt] = (short)bufferedImage.getRaster().getPixel(i, j, nArray)[0];
            }
        }
        ++this.imageCnt;
    }

    public final BufferedImage getPreviewImage() {
        if (!this.renderable) {
            return ClusterImageData.getUnrenderableImage();
        }
        if (this.outputImage == null) {
            this.outputImage = this.renderOutputImage();
            this.imgdata = null;
        }
        return this.outputImage;
    }

    private BufferedImage renderOutputImage() {
        int n;
        int n2;
        WritableRaster writableRaster;
        BufferedImage bufferedImage;
        if (this.outputImageWidth <= 0 || this.outputImageHeight <= 0) {
            bufferedImage = new BufferedImage(100, 100, 12);
            writableRaster = bufferedImage.getRaster();
            for (n2 = 0; n2 < 100; ++n2) {
                for (n = 0; n < 100; ++n) {
                    writableRaster.setSample(n, n2, 0, 1);
                }
            }
            this.addImageToPreview(bufferedImage);
        }
        bufferedImage = new BufferedImage(this.outputImageWidth, this.outputImageHeight, 10);
        writableRaster = bufferedImage.getRaster().createCompatibleWritableRaster();
        if (this.totalImages == 1) {
            for (n2 = 0; n2 < bufferedImage.getWidth(); ++n2) {
                for (n = 0; n < bufferedImage.getHeight(); ++n) {
                    writableRaster.setSample(n2, n, 0, this.imgdata[n2][n][0]);
                }
            }
            bufferedImage.setData(writableRaster);
            return bufferedImage;
        }
        int[][] nArray = ClusterImageData.calculateSdOfImages(this.imgdata, this.imageCnt);
        for (n = 0; n < bufferedImage.getWidth(); ++n) {
            for (int i = 0; i < bufferedImage.getHeight(); ++i) {
                writableRaster.setSample(n, i, 0, nArray[n][i]);
            }
        }
        bufferedImage.setData(writableRaster);
        return bufferedImage;
    }

    private static BufferedImage scaleImage(BufferedImage bufferedImage, int n, int n2) {
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 10);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        AffineTransform affineTransform = AffineTransform.getScaleInstance((double)bufferedImage2.getWidth() / (double)bufferedImage.getWidth(), (double)bufferedImage2.getHeight() / (double)bufferedImage.getHeight());
        graphics2D.drawRenderedImage(bufferedImage, affineTransform);
        graphics2D.dispose();
        return bufferedImage2;
    }

    private static BufferedImage getUnrenderableImage() {
        int n = 200;
        int n2 = 200;
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Color.WHITE);
        graphics2D.drawRect(5, 5, 190, 190);
        Font font = new Font("Sansserif", 1, 22);
        graphics2D.setFont(font);
        graphics2D.setColor(Color.WHITE);
        graphics2D.drawString("Image to Big!", 10, 110);
        graphics2D.dispose();
        return bufferedImage;
    }

    private static int[][] calculateSdOfImages(short[][][] sArray, int n) {
        int n2;
        int n3;
        int n4;
        int n5 = sArray.length;
        int n6 = sArray[0].length;
        int[][] nArray = new int[n5][n6];
        int[][] nArray2 = new int[n5][n6];
        int[][] nArray3 = new int[n5][n6];
        for (n4 = 0; n4 < n5; ++n4) {
            for (n3 = 0; n3 < n6; ++n3) {
                for (n2 = 0; n2 < n; ++n2) {
                    int[] nArray4 = nArray[n4];
                    int n7 = n3;
                    nArray4[n7] = nArray4[n7] + sArray[n4][n3][n2];
                }
            }
        }
        for (n4 = 0; n4 < n5; ++n4) {
            for (n3 = 0; n3 < n6; ++n3) {
                nArray2[n4][n3] = nArray[n4][n3] / n;
            }
        }
        for (n4 = 0; n4 < n5; ++n4) {
            for (n3 = 0; n3 < n6; ++n3) {
                nArray[n4][n3] = 0;
            }
        }
        for (n4 = 0; n4 < n5; ++n4) {
            for (n3 = 0; n3 < n6; ++n3) {
                for (n2 = 0; n2 < n; ++n2) {
                    int[] nArray5 = nArray[n4];
                    int n8 = n3;
                    nArray5[n8] = nArray5[n8] + (sArray[n4][n3][n2] - nArray2[n4][n3]) * (sArray[n4][n3][n2] - nArray2[n4][n3]);
                }
            }
        }
        for (n4 = 0; n4 < n5; ++n4) {
            for (n3 = 0; n3 < n6; ++n3) {
                nArray3[n4][n3] = 255 - (int)Math.sqrt(nArray[n4][n3] / n);
            }
        }
        return nArray3;
    }
}

