/*
 * Decompiled with CFR 0.152.
 */
package at.laborg.briss.model;

import at.laborg.briss.model.PageCluster;
import java.util.ArrayList;
import java.util.List;

public class ClusterDefinition {
    private final List<PageCluster> clusters = new ArrayList<PageCluster>();

    public final PageCluster getSingleCluster(int n) {
        for (PageCluster pageCluster : this.clusters) {
            if (!pageCluster.getAllPages().contains(n)) continue;
            return pageCluster;
        }
        return null;
    }

    public final List<PageCluster> getClusterList() {
        return this.clusters;
    }

    public final void addOrMergeCluster(PageCluster pageCluster) {
        PageCluster pageCluster2 = this.findNearlyEqualCluster(pageCluster);
        if (pageCluster2 != null) {
            pageCluster2.mergeClusters(pageCluster);
        } else {
            this.clusters.add(pageCluster);
        }
    }

    private PageCluster findNearlyEqualCluster(PageCluster pageCluster) {
        for (PageCluster pageCluster2 : this.clusters) {
            if (!pageCluster2.isClusterNearlyEqual(pageCluster)) continue;
            return pageCluster2;
        }
        return null;
    }

    public final void selectAndSetPagesForMerging() {
        for (PageCluster pageCluster : this.clusters) {
            pageCluster.choosePagesToMerge();
        }
    }

    public final int getNrOfPagesToRender() {
        int n = 0;
        for (PageCluster pageCluster : this.clusters) {
            n += pageCluster.getPagesToMerge().size();
        }
        return n;
    }
}

