/*
 * Decompiled with CFR 0.152.
 */
package at.laborg.briss.model;

import at.laborg.briss.model.SingleCluster;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class ClusterCollection {
    private HashMap<Integer, SingleCluster> pageToClustersMapping = new HashMap();
    private HashMap<SingleCluster, List<Integer>> clusterToPagesMapping = new HashMap();
    private boolean dirty = true;

    private <T extends Comparable<? super T>> List<T> asSortedList(Collection<T> collection) {
        ArrayList<T> arrayList = new ArrayList<T>(collection);
        Collections.sort(arrayList);
        return arrayList;
    }

    public List<SingleCluster> getAsList() {
        return this.asSortedList(this.getClusterToPagesMapping().keySet());
    }

    public HashMap<SingleCluster, List<Integer>> getClusterToPagesMapping() {
        return this.clusterToPagesMapping;
    }

    public SingleCluster getSingleCluster(int n) {
        if (this.dirty) {
            for (SingleCluster singleCluster : this.getClusterToPagesMapping().keySet()) {
                for (Integer n2 : this.getClusterToPagesMapping().get(singleCluster)) {
                    this.pageToClustersMapping.put(n2 - 1, singleCluster);
                }
            }
            this.dirty = false;
        }
        return this.pageToClustersMapping.get(n - 1);
    }

    public void addPageToCluster(SingleCluster singleCluster, int n) {
        if (this.getClusterToPagesMapping().containsKey(singleCluster)) {
            List<Integer> list = this.getClusterToPagesMapping().get(singleCluster);
            list.add(n);
        } else {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            arrayList.add(n);
            this.getClusterToPagesMapping().put(singleCluster, arrayList);
        }
        this.dirty = true;
    }
}

