/*
 * Decompiled with CFR 0.152.
 */
package at.laborg.briss.gui;

import at.laborg.briss.BrissGUI;
import at.laborg.briss.gui.ClipBoard;
import at.laborg.briss.gui.DrawableCropRect;
import at.laborg.briss.model.CropFinder;
import at.laborg.briss.model.PageCluster;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class MergedPanel
extends JPanel {
    private static DrawableCropRect curCrop;
    private static Point lastDragPoint;
    private static Point cropStartPoint;
    private static Point popUpMenuPoint;
    private static Point relativeHotCornerGrabDistance;
    private static ActionState actionState;
    private static final int SELECT_BORDER_WIDTH = 1;
    private static final Font BASE_FONT;
    private static final Composite SMOOTH_NORMAL;
    private static final Composite SMOOTH_SELECT;
    private static final Composite XOR_COMPOSITE;
    private static final float[] DASH_PATTERN;
    private static final BasicStroke SELECTED_STROKE;
    private final PageCluster cluster;
    private final List<DrawableCropRect> crops = new ArrayList<DrawableCropRect>();
    private final BufferedImage img;
    private final BrissGUI briss;

    public MergedPanel(PageCluster pageCluster, BrissGUI brissGUI) {
        this.briss = brissGUI;
        this.cluster = pageCluster;
        this.img = pageCluster.getImageData().getPreviewImage();
        Float[] floatArray = CropFinder.getAutoCropFloats(this.img);
        this.setPreferredSize(new Dimension(this.img.getWidth(), this.img.getHeight()));
        this.setSize(new Dimension(this.img.getWidth(), this.img.getHeight()));
        if (pageCluster.getImageData().isRenderable()) {
            MergedPanelMouseAdapter mergedPanelMouseAdapter = new MergedPanelMouseAdapter();
            this.addMouseMotionListener(mergedPanelMouseAdapter);
            this.addMouseListener(mergedPanelMouseAdapter);
        }
        this.addRatiosAsCrops(pageCluster.getRatiosList());
        this.setToolTipText(this.createInfoString(pageCluster));
        this.addKeyListener(new MergedPanelKeyAdapter());
        this.setFocusable(true);
        this.repaint();
    }

    private void addRatiosAsCrops(List<Float[]> list) {
        for (Float[] floatArray : this.cluster.getRatiosList()) {
            DrawableCropRect drawableCropRect = new DrawableCropRect();
            drawableCropRect.x = (int)((float)this.img.getWidth() * floatArray[0].floatValue());
            drawableCropRect.y = (int)((float)this.img.getHeight() * floatArray[3].floatValue());
            drawableCropRect.width = (int)((float)this.img.getWidth() * (1.0f - (floatArray[0].floatValue() + floatArray[2].floatValue())));
            drawableCropRect.height = (int)((float)this.img.getHeight() * (1.0f - (floatArray[1].floatValue() + floatArray[3].floatValue())));
            this.crops.add(drawableCropRect);
        }
    }

    private String createInfoString(PageCluster pageCluster) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append(pageCluster.isEvenPage() ? "Even " : "Odd ").append("page<br>");
        stringBuilder.append(pageCluster.getAllPages().size() + " pages: ");
        int n = 0;
        for (Integer n2 : pageCluster.getAllPages()) {
            stringBuilder.append(n2 + " ");
            if (n++ <= 10) continue;
            n = 0;
            stringBuilder.append("<br>");
        }
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    @Override
    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    @Override
    public void update(Graphics graphics) {
        if (!this.isEnabled()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.drawImage(this.img, null, 0, 0);
        int n = 0;
        for (DrawableCropRect drawableCropRect : this.crops) {
            this.drawNormalCropRectangle(graphics2D, n, drawableCropRect);
            if (drawableCropRect.isSelected()) {
                this.drawSelectionOverlay(graphics2D, drawableCropRect);
            }
            ++n;
        }
        graphics2D.dispose();
    }

    private void drawNormalCropRectangle(Graphics2D graphics2D, int n, DrawableCropRect drawableCropRect) {
        graphics2D.setComposite(SMOOTH_NORMAL);
        graphics2D.setColor(Color.BLUE);
        graphics2D.fill(drawableCropRect);
        graphics2D.setColor(Color.BLACK);
        graphics2D.setFont(this.scaleFont(String.valueOf(n + 1), drawableCropRect));
        graphics2D.drawString(String.valueOf(n + 1), drawableCropRect.x, drawableCropRect.y + drawableCropRect.height);
        int n2 = 20;
        graphics2D.fillRect(drawableCropRect.x, drawableCropRect.y, n2, n2);
        graphics2D.fillRect(drawableCropRect.x + drawableCropRect.width - n2 - 1, drawableCropRect.y + drawableCropRect.height - n2 - 1, n2, n2);
    }

    private void drawSelectionOverlay(Graphics2D graphics2D, DrawableCropRect drawableCropRect) {
        graphics2D.setComposite(XOR_COMPOSITE);
        graphics2D.setColor(Color.BLACK);
        graphics2D.setStroke(SELECTED_STROKE);
        graphics2D.drawRect(drawableCropRect.x + 0, drawableCropRect.y + 0, drawableCropRect.width - 1, drawableCropRect.height - 1);
        int n = Math.round(25.4f * (float)drawableCropRect.width / 72.0f);
        int n2 = Math.round(25.4f * (float)drawableCropRect.height / 72.0f);
        String string = Integer.toString(n) + "x" + Integer.toString(n2);
        graphics2D.setFont(this.scaleFont(string, drawableCropRect));
        graphics2D.setColor(Color.YELLOW);
        graphics2D.setComposite(SMOOTH_SELECT);
        graphics2D.drawString(string, drawableCropRect.x + 1, drawableCropRect.y + drawableCropRect.height - 1);
    }

    private void changeSelectRectangle(Point point) {
        for (DrawableCropRect drawableCropRect : this.crops) {
            if (!drawableCropRect.contains(point)) continue;
            drawableCropRect.setSelected(!drawableCropRect.isSelected());
            break;
        }
        this.repaint();
    }

    public int getWidestSelectedRect() {
        int n = -1;
        for (DrawableCropRect drawableCropRect : this.crops) {
            if (!drawableCropRect.isSelected() || drawableCropRect.width <= n) continue;
            n = drawableCropRect.width;
        }
        return n;
    }

    public int getHeighestSelectedRect() {
        int n = -1;
        for (DrawableCropRect drawableCropRect : this.crops) {
            if (!drawableCropRect.isSelected() || drawableCropRect.height <= n) continue;
            n = drawableCropRect.height;
        }
        return n;
    }

    public int getLeftmostSelectedRect() {
        int n = Integer.MAX_VALUE;
        for (DrawableCropRect drawableCropRect : this.crops) {
            if (!drawableCropRect.isSelected() || drawableCropRect.x >= n) continue;
            n = drawableCropRect.x;
        }
        return n;
    }

    public int getUpmostSelectedRect() {
        int n = Integer.MAX_VALUE;
        for (DrawableCropRect drawableCropRect : this.crops) {
            if (!drawableCropRect.isSelected() || drawableCropRect.y >= n) continue;
            n = drawableCropRect.y;
        }
        return n;
    }

    public Dimension getLargestRect() {
        int n = -1;
        int n2 = -1;
        for (DrawableCropRect drawableCropRect : this.crops) {
            if (drawableCropRect.width > n) {
                n = drawableCropRect.width;
            }
            if (drawableCropRect.height <= n2) continue;
            n2 = drawableCropRect.height;
        }
        return new Dimension(n, n2);
    }

    public void setSelCropWidth(int n) {
        for (DrawableCropRect drawableCropRect : this.crops) {
            if (!drawableCropRect.isSelected()) continue;
            int n2 = n - drawableCropRect.width;
            drawableCropRect.grow(n2 / 2, 0);
        }
        this.updateClusterRatios(this.crops);
        this.repaint();
    }

    public void setSelCropHeight(int n) {
        for (DrawableCropRect drawableCropRect : this.crops) {
            if (!drawableCropRect.isSelected()) continue;
            int n2 = n - drawableCropRect.height;
            drawableCropRect.grow(0, n2 / 2);
        }
        this.updateClusterRatios(this.crops);
        this.repaint();
    }

    public void setSelCropSize(int n, int n2) {
        for (DrawableCropRect drawableCropRect : this.crops) {
            if (!drawableCropRect.isSelected()) continue;
            int n3 = n - drawableCropRect.width;
            int n4 = n2 - drawableCropRect.height;
            drawableCropRect.grow(n3 / 2, n4 / 2);
        }
        this.updateClusterRatios(this.crops);
        this.repaint();
    }

    public void resizeSelCrop(int n, int n2) {
        for (DrawableCropRect drawableCropRect : this.crops) {
            if (!drawableCropRect.isSelected()) continue;
            if (n < 0 && drawableCropRect.width <= -n || n2 < 0 && drawableCropRect.height <= -n2) {
                return;
            }
            drawableCropRect.setSize(drawableCropRect.width + n, drawableCropRect.height + n2);
        }
        this.updateClusterRatios(this.crops);
        this.repaint();
    }

    public void setAllCropSize(int n, int n2) {
        for (DrawableCropRect drawableCropRect : this.crops) {
            drawableCropRect.setSize(n, n2);
        }
        this.updateClusterRatios(this.crops);
        this.repaint();
    }

    public void moveSelelectedCrops(int n, int n2) {
        for (DrawableCropRect drawableCropRect : this.crops) {
            if (!drawableCropRect.isSelected()) continue;
            int n3 = drawableCropRect.x + n;
            int n4 = drawableCropRect.y + n2;
            drawableCropRect.setLocation(n3, n4);
        }
        this.repaint();
    }

    public void moveToSelelectedCrops(int n, int n2) {
        for (DrawableCropRect drawableCropRect : this.crops) {
            if (!drawableCropRect.isSelected()) continue;
            drawableCropRect.setLocation(n, n2);
        }
        this.repaint();
    }

    public void selectCrops(boolean bl) {
        for (DrawableCropRect drawableCropRect : this.crops) {
            drawableCropRect.setSelected(bl);
        }
        this.repaint();
    }

    private void updateClusterRatios(List<DrawableCropRect> list) {
        this.cluster.clearRatios();
        for (DrawableCropRect drawableCropRect : list) {
            this.cluster.addRatios(MergedPanel.getCutRatiosForPdf(drawableCropRect, this.img.getWidth(), this.img.getHeight()));
        }
    }

    private static Float[] getCutRatiosForPdf(Rectangle rectangle, int n, int n2) {
        int n3 = rectangle.x;
        int n4 = n3 + rectangle.width;
        int n5 = rectangle.y;
        int n6 = n5 + rectangle.height;
        if (n3 < 0) {
            n3 = 0;
        }
        if (n4 > n) {
            n4 = n;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        if (n6 > n2) {
            n6 = n2;
        }
        Float[] floatArray = new Float[]{Float.valueOf((float)n3 / (float)n), Float.valueOf((float)(n2 - n6) / (float)n2), Float.valueOf(1.0f - (float)n4 / (float)n), Float.valueOf(1.0f - (float)(n2 - n5) / (float)n2)};
        return floatArray;
    }

    private Font scaleFont(String string, Rectangle rectangle) {
        int n = BASE_FONT.getSize();
        int n2 = this.getFontMetrics(BASE_FONT).stringWidth(string);
        int n3 = this.getFontMetrics(BASE_FONT).getHeight();
        if (n2 == 0 || n3 == 0) {
            return BASE_FONT;
        }
        float f = rectangle.width / n2;
        float f2 = rectangle.height / n3;
        float f3 = f * (float)n;
        float f4 = f2 * (float)n;
        return BASE_FONT.deriveFont(f2 > f ? f3 : f4);
    }

    private void copyToClipBoard() {
        ClipBoard.getInstance().clear();
        for (DrawableCropRect drawableCropRect : this.crops) {
            if (!drawableCropRect.isSelected()) continue;
            ClipBoard.getInstance().addCrop(drawableCropRect);
        }
        this.updateClusterRatios(this.crops);
        this.repaint();
    }

    private void pasteFromClipBoard() {
        for (DrawableCropRect drawableCropRect : ClipBoard.getInstance().getCrops()) {
            if (this.crops.contains(drawableCropRect)) continue;
            DrawableCropRect drawableCropRect2 = new DrawableCropRect(drawableCropRect);
            this.crops.add(drawableCropRect2);
        }
        ClipBoard.getInstance().clear();
        this.updateClusterRatios(this.crops);
        this.repaint();
    }

    private void alignSelected(Point point) {
        for (DrawableCropRect drawableCropRect : this.crops) {
            if (!drawableCropRect.contains(point)) continue;
            this.briss.alignSelRects(drawableCropRect.x, drawableCropRect.y, drawableCropRect.width, drawableCropRect.height);
            break;
        }
    }

    private void deleteAllSelected() {
        ArrayList<DrawableCropRect> arrayList = new ArrayList<DrawableCropRect>();
        for (DrawableCropRect drawableCropRect : this.crops) {
            if (!drawableCropRect.isSelected()) continue;
            arrayList.add(drawableCropRect);
        }
        this.crops.removeAll(arrayList);
        this.updateClusterRatios(this.crops);
        this.repaint();
    }

    private void clipCropsToVisibleArea() {
        for (DrawableCropRect drawableCropRect : this.crops) {
            if (drawableCropRect.x < 0) {
                drawableCropRect.width -= -drawableCropRect.x;
                drawableCropRect.x = 0;
            }
            if (drawableCropRect.y < 0) {
                drawableCropRect.height -= -drawableCropRect.y;
                drawableCropRect.y = 0;
            }
            if (drawableCropRect.x + drawableCropRect.width > this.getWidth()) {
                drawableCropRect.width = this.getWidth() - drawableCropRect.x;
            }
            if (drawableCropRect.y + drawableCropRect.height <= this.getHeight()) continue;
            drawableCropRect.height = this.getHeight() - drawableCropRect.y;
        }
    }

    private void removeToSmallCrops() {
        ArrayList<DrawableCropRect> arrayList = new ArrayList<DrawableCropRect>();
        for (DrawableCropRect drawableCropRect : this.crops) {
            if (!(drawableCropRect.getWidth() < 40.0) && !(drawableCropRect.getHeight() < 40.0)) continue;
            arrayList.add(drawableCropRect);
        }
        this.crops.removeAll(arrayList);
    }

    static {
        actionState = ActionState.NOTHING;
        BASE_FONT = new Font(null, 0, 10);
        SMOOTH_NORMAL = AlphaComposite.getInstance(3, 0.2f);
        SMOOTH_SELECT = AlphaComposite.getInstance(3, 0.5f);
        XOR_COMPOSITE = AlphaComposite.getInstance(3, 0.8f);
        DASH_PATTERN = new float[]{25.0f, 25.0f};
        SELECTED_STROKE = new BasicStroke(1.0f, 2, 2, 1.0f, DASH_PATTERN, 0.0f);
    }

    private class MergedPanelMouseAdapter
    extends MouseAdapter
    implements ActionListener {
        private MergedPanelMouseAdapter() {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (MergedPanel.this.contains(mouseEvent.getPoint())) {
                MergedPanel.this.requestFocusInWindow();
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if ("Delete rectangle".equals(actionEvent.getActionCommand())) {
                for (DrawableCropRect drawableCropRect : MergedPanel.this.crops) {
                    if (!drawableCropRect.contains(popUpMenuPoint)) continue;
                    MergedPanel.this.crops.remove(drawableCropRect);
                    break;
                }
                MergedPanel.this.cluster.clearRatios();
                MergedPanel.this.repaint();
            } else if ("Select/Deselect rectangle".equals(actionEvent.getActionCommand())) {
                MergedPanel.this.changeSelectRectangle(popUpMenuPoint);
            } else if ("Copy Selected rectangles".equals(actionEvent.getActionCommand())) {
                MergedPanel.this.copyToClipBoard();
            } else if ("Paste rectangles".equals(actionEvent.getActionCommand())) {
                MergedPanel.this.pasteFromClipBoard();
            } else if ("Align selected rectangles".equals(actionEvent.getActionCommand())) {
                MergedPanel.this.alignSelected(popUpMenuPoint);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            switch (actionState) {
                case DRAWING_NEW_CROP: {
                    if (cropStartPoint == null) {
                        cropStartPoint = point;
                    }
                    curCrop.x = point.x < cropStartPoint.x ? point.x : cropStartPoint.x;
                    curCrop.width = Math.abs(point.x - cropStartPoint.x);
                    curCrop.y = point.y < cropStartPoint.y ? point.y : cropStartPoint.y;
                    curCrop.height = Math.abs(point.y - cropStartPoint.y);
                    break;
                }
                case MOVE_CROP: {
                    if (lastDragPoint == null) {
                        lastDragPoint = point;
                    }
                    if (mouseEvent.isShiftDown()) {
                        MergedPanel.this.briss.moveSelectedRects(point.x - lastDragPoint.x, point.y - lastDragPoint.y);
                    } else {
                        curCrop.translate(point.x - lastDragPoint.x, point.y - lastDragPoint.y);
                    }
                    lastDragPoint = point;
                    break;
                }
                case RESIZING_HOTCORNER_LR: {
                    if (lastDragPoint == null) {
                        lastDragPoint = point;
                    }
                    if (mouseEvent.isShiftDown()) {
                        MergedPanel.this.briss.resizeSelRects(point.x - lastDragPoint.x, point.y - lastDragPoint.y);
                    } else {
                        point.translate(relativeHotCornerGrabDistance.x, relativeHotCornerGrabDistance.y);
                        curCrop.setNewHotCornerLR(point);
                    }
                    lastDragPoint = point;
                    break;
                }
                case RESIZING_HOTCORNER_UL: {
                    if (lastDragPoint == null) {
                        lastDragPoint = point;
                    }
                    if (mouseEvent.isShiftDown()) {
                        MergedPanel.this.briss.resizeSelRects(lastDragPoint.x - point.x, lastDragPoint.y - point.y);
                        MergedPanel.this.briss.moveSelectedRects(point.x - lastDragPoint.x, point.y - lastDragPoint.y);
                    } else {
                        point.translate(relativeHotCornerGrabDistance.x, relativeHotCornerGrabDistance.y);
                        curCrop.setNewHotCornerUL(point);
                    }
                    lastDragPoint = point;
                }
            }
            MergedPanel.this.repaint();
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            if (mouseEvent.isPopupTrigger()) {
                this.showPopUpMenu(mouseEvent);
            }
            if (mouseEvent.isControlDown()) {
                MergedPanel.this.changeSelectRectangle(point);
                return;
            }
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                for (DrawableCropRect drawableCropRect : MergedPanel.this.crops) {
                    if (!drawableCropRect.containsInHotCornerUL(point)) continue;
                    MergedPanel.actionState = ActionState.RESIZING_HOTCORNER_UL;
                    relativeHotCornerGrabDistance = new Point(drawableCropRect.x - point.x, drawableCropRect.y - point.y);
                    curCrop = drawableCropRect;
                    return;
                }
                for (DrawableCropRect drawableCropRect : MergedPanel.this.crops) {
                    if (!drawableCropRect.containsInHotCornerLR(point)) continue;
                    MergedPanel.actionState = ActionState.RESIZING_HOTCORNER_LR;
                    relativeHotCornerGrabDistance = new Point(drawableCropRect.x + drawableCropRect.width - point.x, drawableCropRect.y + drawableCropRect.height - point.y);
                    curCrop = drawableCropRect;
                    return;
                }
                for (DrawableCropRect drawableCropRect : MergedPanel.this.crops) {
                    if (!drawableCropRect.contains(point)) continue;
                    MergedPanel.actionState = ActionState.MOVE_CROP;
                    curCrop = drawableCropRect;
                    return;
                }
                MergedPanel.actionState = ActionState.DRAWING_NEW_CROP;
                if (curCrop == null) {
                    curCrop = new DrawableCropRect();
                    MergedPanel.this.crops.add(curCrop);
                    cropStartPoint = point;
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showPopUpMenu(mouseEvent);
            }
            MergedPanel.this.clipCropsToVisibleArea();
            MergedPanel.this.removeToSmallCrops();
            MergedPanel.this.updateClusterRatios(MergedPanel.this.crops);
            MergedPanel.actionState = ActionState.NOTHING;
            cropStartPoint = null;
            lastDragPoint = null;
            curCrop = null;
            MergedPanel.this.repaint();
        }

        private void showPopUpMenu(MouseEvent mouseEvent) {
            popUpMenuPoint = mouseEvent.getPoint();
            new PopUpMenuForCropRectangles().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }

        private class PopUpMenuForCropRectangles
        extends JPopupMenu {
            public static final String DELETE = "Delete rectangle";
            public static final String SELECT_DESELECT = "Select/Deselect rectangle";
            public static final String COPY = "Copy Selected rectangles";
            public static final String PASTE = "Paste rectangles";
            public static final String ALIGN_SELECTED = "Align selected rectangles";

            public PopUpMenuForCropRectangles() {
                Serializable serializable2;
                Object object2;
                boolean bl = false;
                for (Object object2 : MergedPanel.this.crops) {
                    if (!((Rectangle)object2).contains(popUpMenuPoint)) continue;
                    bl = true;
                }
                if (bl) {
                    JMenuItem jMenuItem = new JMenuItem(DELETE);
                    jMenuItem.addActionListener(MergedPanelMouseAdapter.this);
                    this.add(jMenuItem);
                    object2 = new JMenuItem(SELECT_DESELECT);
                    ((AbstractButton)object2).addActionListener(MergedPanelMouseAdapter.this);
                    this.add((JMenuItem)object2);
                }
                boolean bl2 = false;
                for (Serializable serializable2 : MergedPanel.this.crops) {
                    if (!((DrawableCropRect)serializable2).isSelected()) continue;
                    bl2 = true;
                }
                object2 = new JMenuItem(COPY);
                ((AbstractButton)object2).addActionListener(MergedPanelMouseAdapter.this);
                ((JMenuItem)object2).setEnabled(bl2);
                this.add((JMenuItem)object2);
                serializable2 = new JMenuItem(PASTE);
                ((AbstractButton)serializable2).addActionListener(MergedPanelMouseAdapter.this);
                ((JMenuItem)serializable2).setEnabled(ClipBoard.getInstance().getAmountOfCropsInClipBoard() > 0);
                this.add((JMenuItem)serializable2);
                JMenuItem jMenuItem = new JMenuItem(ALIGN_SELECTED);
                jMenuItem.addActionListener(MergedPanelMouseAdapter.this);
                jMenuItem.setEnabled(true);
                this.add(jMenuItem);
            }
        }
    }

    private class MergedPanelKeyAdapter
    extends KeyAdapter {
        private MergedPanelKeyAdapter() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 67: {
                    if (keyEvent.getModifiers() != 2) break;
                    MergedPanel.this.copyToClipBoard();
                    break;
                }
                case 86: {
                    if (keyEvent.getModifiers() != 2) break;
                    MergedPanel.this.pasteFromClipBoard();
                    break;
                }
                case 127: {
                    MergedPanel.this.deleteAllSelected();
                    break;
                }
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    int n = 0;
                    int n2 = 0;
                    switch (keyEvent.getKeyCode()) {
                        case 37: {
                            n = -1;
                            break;
                        }
                        case 39: {
                            n = 1;
                            break;
                        }
                        case 38: {
                            n2 = -1;
                            break;
                        }
                        case 40: {
                            n2 = 1;
                        }
                    }
                    if ((keyEvent.getModifiers() & 1) != 0) {
                        n *= 10;
                        n2 *= 10;
                    }
                    if ((keyEvent.getModifiers() & 2) != 0) {
                        MergedPanel.this.briss.resizeSelRects(n, n2);
                        break;
                    }
                    MergedPanel.this.briss.moveSelectedRects(n, n2);
                    break;
                }
            }
        }
    }

    private static enum ActionState {
        NOTHING,
        DRAWING_NEW_CROP,
        RESIZING_HOTCORNER_UL,
        RESIZING_HOTCORNER_LR,
        MOVE_CROP;

    }
}

