/*
 * Decompiled with CFR 0.152.
 */
package at.laborg.briss;

import at.laborg.briss.model.ClusterJob;
import at.laborg.briss.model.CropJob;
import at.laborg.briss.model.SingleCluster;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfImportedPage;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfSmartCopy;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.SimpleBookmark;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class CropManager {
    public static CropJob createCropJob(ClusterJob clusterJob) throws IOException {
        File file = clusterJob.getSource();
        if (file != null && file.exists()) {
            PdfReader pdfReader = new PdfReader(file.getAbsolutePath());
            CropJob cropJob = new CropJob(file, pdfReader.getNumberOfPages(), pdfReader.getInfo(), SimpleBookmark.getBookmark((PdfReader)pdfReader));
            pdfReader.close();
            cropJob.setClusterCollection(clusterJob.getClusterCollection());
            return cropJob;
        }
        return null;
    }

    public static CropJob createCropJob(File file) throws IOException {
        CropJob cropJob = null;
        if (file != null && file.exists()) {
            PdfReader pdfReader = new PdfReader(file.getAbsolutePath());
            cropJob = new CropJob(file, pdfReader.getNumberOfPages(), pdfReader.getInfo(), SimpleBookmark.getBookmark((PdfReader)pdfReader));
            pdfReader.close();
            return cropJob;
        }
        return cropJob;
    }

    public static void crop(CropJob cropJob) throws IOException, DocumentException {
        File file = CropManager.copyToMultiplePages(cropJob);
        CropManager.cropMultipliedFile(file, cropJob);
    }

    private static File copyToMultiplePages(CropJob cropJob) throws IOException, DocumentException {
        PdfReader pdfReader = new PdfReader(cropJob.getSource().getAbsolutePath());
        Document document = new Document();
        File file = File.createTempFile("cropped", ".pdf");
        PdfSmartCopy pdfSmartCopy = new PdfSmartCopy(document, (OutputStream)new FileOutputStream(file));
        document.open();
        for (int i = 1; i <= cropJob.getSourcePageCount(); ++i) {
            SingleCluster singleCluster = cropJob.getClusterCollection().getSingleCluster(i);
            PdfImportedPage pdfImportedPage = pdfSmartCopy.getImportedPage(pdfReader, i);
            pdfSmartCopy.addPage(pdfImportedPage);
            for (int j = 1; j < singleCluster.getRatiosList().size(); ++j) {
                pdfSmartCopy.addPage(pdfImportedPage);
            }
        }
        document.close();
        pdfSmartCopy.close();
        pdfReader.close();
        return file;
    }

    private static void cropMultipliedFile(File file, CropJob cropJob) throws FileNotFoundException, DocumentException, IOException {
        PdfReader pdfReader = new PdfReader(file.getAbsolutePath());
        PdfStamper pdfStamper = new PdfStamper(pdfReader, (OutputStream)new FileOutputStream(cropJob.getDestinationFile()));
        pdfStamper.setMoreInfo(cropJob.getSourceMetaInfo());
        int n = 1;
        for (int i = 1; i <= cropJob.getSourcePageCount(); ++i) {
            SingleCluster singleCluster = cropJob.getClusterCollection().getSingleCluster(i);
            if (singleCluster.getRatiosList().size() == 0) {
                ++n;
                continue;
            }
            for (Float[] floatArray : singleCluster.getRatiosList()) {
                PdfDictionary pdfDictionary = pdfReader.getPageN(n);
                ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>();
                arrayList.add(pdfReader.getBoxSize(n, "media"));
                arrayList.add(pdfReader.getBoxSize(n, "crop"));
                int n2 = pdfReader.getPageRotation(n);
                Rectangle rectangle = CropManager.calculateScaledRectangle(arrayList, floatArray, n2);
                PdfArray pdfArray = new PdfArray();
                pdfArray.add((PdfObject)new PdfNumber(rectangle.getLeft()));
                pdfArray.add((PdfObject)new PdfNumber(rectangle.getBottom()));
                pdfArray.add((PdfObject)new PdfNumber(rectangle.getRight()));
                pdfArray.add((PdfObject)new PdfNumber(rectangle.getTop()));
                pdfDictionary.put(PdfName.CROPBOX, (PdfObject)pdfArray);
                pdfDictionary.put(PdfName.MEDIABOX, (PdfObject)pdfArray);
                ++n;
            }
            Object object = new int[2];
            object[0] = n - 1;
            object[1] = cropJob.getSourcePageCount() + (n - i);
            SimpleBookmark.shiftPageNumbers(cropJob.getSourceBookmarks(), (int)(singleCluster.getRatiosList().size() - 1), (int[])object);
        }
        pdfStamper.setOutlines(cropJob.getSourceBookmarks());
        pdfStamper.close();
        pdfReader.close();
    }

    private static Rectangle calculateScaledRectangle(List<Rectangle> list, Float[] floatArray, int n) {
        Rectangle rectangle3;
        if (floatArray == null || list.size() == 0) {
            return null;
        }
        Rectangle rectangle2 = null;
        float f = Float.MAX_VALUE;
        for (Rectangle rectangle3 : list) {
            if (rectangle3 == null) continue;
            if (rectangle2 == null) {
                rectangle2 = rectangle3;
            }
            if (!(f > rectangle3.getWidth() * rectangle3.getHeight())) continue;
            f = rectangle3.getWidth() * rectangle3.getHeight();
            rectangle2 = rectangle3;
        }
        if (rectangle2 == null) {
            return null;
        }
        Object object = CropManager.rotateRatios(floatArray, n);
        rectangle3 = new Rectangle(rectangle2);
        rectangle3.setLeft(rectangle2.getLeft() + rectangle2.getWidth() * object[0]);
        rectangle3.setBottom(rectangle2.getBottom() + rectangle2.getHeight() * object[1]);
        rectangle3.setRight(rectangle2.getLeft() + rectangle2.getWidth() * (1.0f - object[2]));
        rectangle3.setTop(rectangle2.getBottom() + rectangle2.getHeight() * (1.0f - object[3]));
        return rectangle3;
    }

    private static float[] rotateRatios(Float[] floatArray, int n) {
        float[] fArray = new float[4];
        for (int i = 0; i < 4; ++i) {
            fArray[i] = floatArray[i].floatValue();
        }
        while (n > 0 && n < 360) {
            float f = fArray[0];
            fArray[0] = fArray[1];
            fArray[1] = fArray[2];
            fArray[2] = fArray[3];
            fArray[3] = f;
            n += 90;
        }
        return fArray;
    }
}

