/*
 * Decompiled with CFR 0.152.
 */
package at.laborg.briss;

import at.laborg.briss.model.ClusterCollection;
import at.laborg.briss.model.ClusterJob;
import at.laborg.briss.model.SingleCluster;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfReader;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import org.jpedal.PdfDecoder;
import org.jpedal.exception.PdfException;

public class ClusterManager {
    public static ClusterJob createClusterJob(File file) throws IOException, PdfException {
        PdfReader pdfReader = new PdfReader(file.getAbsolutePath());
        ClusterJob clusterJob = new ClusterJob(file);
        pdfReader.close();
        return clusterJob;
    }

    /*
     * WARNING - void declaration
     */
    public static void clusterPages(ClusterJob clusterJob) throws IOException {
        PdfReader pdfReader = new PdfReader(clusterJob.getSource().getAbsolutePath());
        ClusterCollection clusterCollection = clusterJob.getClusterCollection();
        for (int i = 1; i <= pdfReader.getNumberOfPages(); ++i) {
            void object;
            Rectangle rectangle = pdfReader.getBoxSize(i, "crop");
            if (rectangle == null) {
                Rectangle rectangle2 = pdfReader.getBoxSize(i, "media");
            }
            int n = -1;
            if (clusterJob.getExcludedPageSet() != null && clusterJob.getExcludedPageSet().contains(i)) {
                n = i;
            }
            SingleCluster singleCluster = new SingleCluster(i % 2 == 0, (int)object.getWidth(), (int)object.getHeight(), n);
            clusterCollection.addPageToCluster(singleCluster, i);
        }
        for (SingleCluster singleCluster : clusterCollection.getClusterToPagesMapping().keySet()) {
            singleCluster.choosePagesToMerge(clusterCollection.getClusterToPagesMapping().get(singleCluster));
        }
        pdfReader.close();
    }

    public static class ClusterRenderWorker
    extends Thread {
        public int workerUnitCounter = 1;
        private final ClusterJob clusterJob;

        public ClusterRenderWorker(ClusterJob clusterJob) {
            this.clusterJob = clusterJob;
        }

        @Override
        public void run() {
            PdfDecoder pdfDecoder = new PdfDecoder(true);
            try {
                pdfDecoder.openPdfFile(this.clusterJob.getSource().getAbsolutePath());
            }
            catch (PdfException pdfException) {
                pdfException.printStackTrace();
            }
            for (SingleCluster singleCluster : this.clusterJob.getClusterCollection().getAsList()) {
                for (Integer n : singleCluster.getPagesToMerge()) {
                    try {
                        if (!singleCluster.getImageData().isRenderable()) continue;
                        BufferedImage bufferedImage = pdfDecoder.getPageAsImage(n.intValue());
                        singleCluster.getImageData().addImageToPreview(bufferedImage);
                        ++this.workerUnitCounter;
                    }
                    catch (PdfException pdfException) {
                        pdfException.printStackTrace();
                    }
                }
            }
            pdfDecoder.closePdfFile();
        }
    }
}

