/*
 * Decompiled with CFR 0.152.
 */
package at.laborg.briss;

import at.laborg.briss.BrissGUI;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.TransferHandler;
import org.jpedal.exception.PdfException;

final class BrissTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 1L;
    private final BrissGUI brissGUI;

    BrissTransferHandler(BrissGUI brissGUI) {
        this.brissGUI = brissGUI;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport transferSupport) {
        return transferSupport.isDataFlavorSupported(DataFlavor.stringFlavor);
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport transferSupport) {
        if (!this.canImport(transferSupport)) {
            return false;
        }
        Transferable transferable = transferSupport.getTransferable();
        try {
            String[] stringArray;
            String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            for (String string2 : stringArray = string.split("\n")) {
                string2 = string2.replaceAll("\\n", "");
                string2 = string2.replaceAll("\\t", "");
                if (!(string2 = string2.replaceAll("\\r", "")).trim().endsWith(".pdf")) continue;
                File file = null;
                try {
                    URI uRI = new URI(string2);
                    file = new File(uRI);
                }
                catch (URISyntaxException uRISyntaxException) {
                    uRISyntaxException.printStackTrace();
                }
                try {
                    this.brissGUI.importNewPdfFile(file);
                }
                catch (PdfException pdfException) {
                    pdfException.printStackTrace();
                }
                break;
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            unsupportedFlavorException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return true;
    }
}

