/*
 * Decompiled with CFR 0.152.
 */
package at.laborg.briss;

import at.laborg.briss.BrissTransferHandler;
import at.laborg.briss.exception.CropException;
import at.laborg.briss.gui.HelpDialog;
import at.laborg.briss.gui.MergedPanel;
import at.laborg.briss.gui.WrapLayout;
import at.laborg.briss.model.ClusterDefinition;
import at.laborg.briss.model.CropDefinition;
import at.laborg.briss.model.PageCluster;
import at.laborg.briss.model.PageExcludes;
import at.laborg.briss.model.WorkingSet;
import at.laborg.briss.utils.BrissFileHandling;
import at.laborg.briss.utils.ClusterCreator;
import at.laborg.briss.utils.ClusterRenderWorker;
import at.laborg.briss.utils.DesktopHelper;
import at.laborg.briss.utils.DocumentCropper;
import at.laborg.briss.utils.PDFFileFilter;
import com.itextpdf.text.DocumentException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.jpedal.exception.PdfException;

public class BrissGUI
extends JFrame
implements ActionListener,
PropertyChangeListener,
ComponentListener {
    private static final String EXCLUDE_PAGES_DESCRIPTION = "Enter pages to be excluded from merging (e.g.: \"1-4;6;9\").\nFirst page has number: 1\nIf you don't know what you should do just press \"Cancel\"";
    private static final String SET_SIZE_DESCRIPTION = "Enter size in milimeters (width height)";
    private static final String SET_POSITION_DESCRIPTION = "Enter position in milimeters (x y)";
    private static final String LOAD = "Load File";
    private static final String CROP = "Crop PDF";
    private static final String EXIT = "Exit";
    private static final String MAXIMIZE_WIDTH = "Maximize to width";
    private static final String MAXIMIZE_HEIGHT = "Maximize to height";
    private static final String MAXIMIZE_ALL = "Maximize All";
    private static final String EXCLUDE_OTHER_PAGES = "Exclude other pages";
    private static final String PREVIEW = "Preview";
    private static final String DONATE = "Donate";
    private static final String HELP = "Show help";
    private static final String MAXIMIZE_SIZE = "Maximize to size (all)";
    private static final String SET_SIZE = "Set size (selected)";
    private static final String SET_POSITION = "Set position (selected)";
    private static final String MOVE_LEFT = "Move left (selected)";
    private static final String MOVE_RIGHT = "Move right (selected)";
    private static final String MOVE_UP = "Move up (selected)";
    private static final String MOVE_DOWN = "Move down (selected)";
    private static final String SELECT_ALL = "Select all";
    private static final String SELECT_NONE = "Select none";
    private static final String DONATION_URI = "http://sourceforge.net/project/project_donations.php?group_id=320676";
    private static final String RES_ICON_PATH = "/Briss_icon_032x032.gif";
    private JMenuBar menuBar;
    private JPanel previewPanel;
    private JProgressBar progressBar;
    private JMenuItem loadButton;
    private JMenuItem cropButton;
    private JMenuItem maximizeWidthButton;
    private JMenuItem maximizeHeightButton;
    private JMenuItem showPreviewButton;
    private JMenuItem showHelpButton;
    private JMenuItem openDonationLinkButton;
    private JMenuItem excludePagesButton;
    private JMenuItem maximizeSizeButton;
    private JMenuItem maximizeAllButton;
    private JMenuItem setSizeButton;
    private JMenuItem setPositionButton;
    private JMenuItem moveLeftButton;
    private JMenuItem moveRightButton;
    private JMenuItem moveUpButton;
    private JMenuItem moveDownButton;
    private JMenuItem selectAllButton;
    private JMenuItem selectNoneButton;
    private List<MergedPanel> mergedPanels = null;
    private File lastOpenDir;
    private WorkingSet workingSet;

    public BrissGUI(String[] stringArray) {
        super("BRISS - BRight Snippet Sire");
        this.init();
        this.tryToLoadFileFromArgument(stringArray);
    }

    private void tryToLoadFileFromArgument(String[] stringArray) {
        if (stringArray.length == 0) {
            return;
        }
        File file = new File(stringArray[0]);
        if (file.exists() && file.getAbsolutePath().trim().endsWith(".pdf")) {
            try {
                this.importNewPdfFile(file);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, iOException.getMessage(), "Briss error", 0);
            }
            catch (PdfException pdfException) {
                JOptionPane.showMessageDialog(this, pdfException.getMessage(), "Briss error", 0);
            }
        }
    }

    private void init() {
        this.setDefaultCloseOperation(3);
        this.setTransferHandler(new BrissTransferHandler(this));
        this.setUILook();
        this.loadIcon();
        this.menuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        JMenu jMenu2 = new JMenu("Rectangle");
        jMenu2.setMnemonic(82);
        JMenu jMenu3 = new JMenu("Action");
        jMenu3.setMnemonic(65);
        this.menuBar.add(jMenu);
        this.menuBar.add(jMenu2);
        this.menuBar.add(jMenu3);
        this.loadButton = new JMenuItem(LOAD, 76);
        this.loadButton.addActionListener(this);
        this.loadButton.setEnabled(true);
        this.loadButton.setAccelerator(KeyStroke.getKeyStroke(76, 0));
        jMenu.add(this.loadButton);
        jMenu.addSeparator();
        this.openDonationLinkButton = new JMenuItem(DONATE);
        this.openDonationLinkButton.addActionListener(this);
        jMenu.add(this.openDonationLinkButton);
        this.excludePagesButton = new JMenuItem(EXCLUDE_OTHER_PAGES);
        this.excludePagesButton.addActionListener(this);
        this.excludePagesButton.setEnabled(false);
        this.excludePagesButton.setAccelerator(KeyStroke.getKeyStroke(69, 0));
        jMenu.add(this.excludePagesButton);
        this.showHelpButton = new JMenuItem(HELP);
        this.showHelpButton.addActionListener(this);
        jMenu.add(this.showHelpButton);
        jMenu.addSeparator();
        JMenuItem jMenuItem = new JMenuItem(EXIT, 69);
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        this.cropButton = new JMenuItem(CROP, 67);
        this.cropButton.addActionListener(this);
        this.cropButton.setEnabled(false);
        this.cropButton.setAccelerator(KeyStroke.getKeyStroke(67, 0));
        jMenu3.add(this.cropButton);
        this.showPreviewButton = new JMenuItem(PREVIEW, 80);
        this.showPreviewButton.addActionListener(this);
        this.showPreviewButton.setEnabled(false);
        this.showPreviewButton.setAccelerator(KeyStroke.getKeyStroke(80, 0));
        jMenu3.add(this.showPreviewButton);
        this.maximizeWidthButton = new JMenuItem(MAXIMIZE_WIDTH, 87);
        this.maximizeWidthButton.addActionListener(this);
        this.maximizeWidthButton.setEnabled(false);
        this.maximizeWidthButton.setAccelerator(KeyStroke.getKeyStroke(87, 0));
        jMenu2.add(this.maximizeWidthButton);
        this.maximizeHeightButton = new JMenuItem(MAXIMIZE_HEIGHT, 72);
        this.maximizeHeightButton.addActionListener(this);
        this.maximizeHeightButton.setEnabled(false);
        this.maximizeHeightButton.setAccelerator(KeyStroke.getKeyStroke(72, 0));
        jMenu2.add(this.maximizeHeightButton);
        this.maximizeSizeButton = new JMenuItem(MAXIMIZE_SIZE, 90);
        this.maximizeSizeButton.addActionListener(this);
        this.maximizeSizeButton.setEnabled(false);
        this.maximizeSizeButton.setAccelerator(KeyStroke.getKeyStroke(77, 0));
        jMenu2.add(this.maximizeSizeButton);
        this.maximizeAllButton = new JMenuItem(MAXIMIZE_ALL, 86);
        this.maximizeAllButton.addActionListener(this);
        this.maximizeAllButton.setEnabled(false);
        this.maximizeAllButton.setAccelerator(KeyStroke.getKeyStroke(86, 0));
        jMenu2.add(this.maximizeAllButton);
        this.setSizeButton = new JMenuItem(SET_SIZE, 83);
        this.setSizeButton.addActionListener(this);
        this.setSizeButton.setEnabled(false);
        this.setSizeButton.setAccelerator(KeyStroke.getKeyStroke(83, 0));
        jMenu2.add(this.setSizeButton);
        this.setPositionButton = new JMenuItem(SET_POSITION, 79);
        this.setPositionButton.addActionListener(this);
        this.setPositionButton.setEnabled(false);
        this.setPositionButton.setAccelerator(KeyStroke.getKeyStroke(79, 0));
        jMenu2.add(this.setPositionButton);
        jMenu2.addSeparator();
        this.moveLeftButton = new JMenuItem(MOVE_LEFT, 37);
        this.moveLeftButton.addActionListener(this);
        this.moveLeftButton.setEnabled(false);
        this.moveLeftButton.setAccelerator(KeyStroke.getKeyStroke(37, 0));
        jMenu2.add(this.moveLeftButton);
        this.moveRightButton = new JMenuItem(MOVE_RIGHT, 39);
        this.moveRightButton.addActionListener(this);
        this.moveRightButton.setEnabled(false);
        this.moveRightButton.setAccelerator(KeyStroke.getKeyStroke(39, 0));
        jMenu2.add(this.moveRightButton);
        this.moveUpButton = new JMenuItem(MOVE_UP, 38);
        this.moveUpButton.addActionListener(this);
        this.moveUpButton.setEnabled(false);
        this.moveUpButton.setAccelerator(KeyStroke.getKeyStroke(38, 0));
        jMenu2.add(this.moveUpButton);
        this.moveDownButton = new JMenuItem(MOVE_DOWN, 40);
        this.moveDownButton.addActionListener(this);
        this.moveDownButton.setEnabled(false);
        this.moveDownButton.setAccelerator(KeyStroke.getKeyStroke(40, 0));
        jMenu2.add(this.moveDownButton);
        jMenu2.addSeparator();
        this.selectAllButton = new JMenuItem(SELECT_ALL, 0);
        this.selectAllButton.addActionListener(this);
        this.selectAllButton.setEnabled(false);
        this.selectAllButton.setAccelerator(KeyStroke.getKeyStroke(65, 0));
        jMenu2.add(this.selectAllButton);
        this.selectNoneButton = new JMenuItem(SELECT_NONE, 0);
        this.selectNoneButton.addActionListener(this);
        this.selectNoneButton.setEnabled(false);
        this.selectNoneButton.setAccelerator(KeyStroke.getKeyStroke(78, 0));
        jMenu2.add(this.selectNoneButton);
        this.setJMenuBar(this.menuBar);
        this.previewPanel = new JPanel();
        this.previewPanel.setLayout(new WrapLayout(0, 4, 4));
        this.previewPanel.setEnabled(true);
        this.previewPanel.setBackground(Color.BLACK);
        this.previewPanel.addComponentListener(this);
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setStringPainted(true);
        this.progressBar.setPreferredSize(new Dimension(400, 30));
        this.progressBar.setEnabled(true);
        JScrollPane jScrollPane = new JScrollPane(this.previewPanel, 22, 30);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(30);
        this.add((Component)jScrollPane, "Center");
        this.add((Component)this.progressBar, "Last");
        this.pack();
        this.setVisible(true);
    }

    private void setUILook() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            System.out.println("Unable to load native look and feel");
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    private void loadIcon() {
        InputStream inputStream = this.getClass().getResourceAsStream(RES_ICON_PATH);
        byte[] byArray = new byte[102400];
        try {
            int n = inputStream.read(byArray);
            byte[] byArray2 = Arrays.copyOf(byArray, n);
            this.setIconImage(new ImageIcon(byArray2).getImage());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static PageExcludes getExcludedPages() {
        boolean bl = false;
        String string = "";
        return null;
    }

    private File getCropFileDestination(File file) {
        File file2 = BrissFileHandling.getRecommendedDestination(file);
        JFileChooser jFileChooser = new JFileChooser(this.lastOpenDir);
        jFileChooser.setSelectedFile(file2);
        jFileChooser.setFileFilter(new PDFFileFilter());
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            return jFileChooser.getSelectedFile();
        }
        return null;
    }

    private File getNewFileToCrop() {
        JFileChooser jFileChooser = new JFileChooser(this.lastOpenDir);
        jFileChooser.setFileFilter(new PDFFileFilter());
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            return jFileChooser.getSelectedFile();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(DONATE)) {
            try {
                DesktopHelper.openDonationLink(DONATION_URI);
                return;
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, iOException.getMessage(), "Error occured while loading", 0);
            }
            return;
        } else if (actionEvent.getActionCommand().equals(EXIT)) {
            System.exit(0);
            return;
        } else if (actionEvent.getActionCommand().equals(HELP)) {
            new HelpDialog((Frame)this, "Briss Help", Dialog.ModalityType.MODELESS);
            return;
        } else if (actionEvent.getActionCommand().equals(MAXIMIZE_HEIGHT)) {
            this.maximizeHeightInSelectedRects();
            return;
        } else if (actionEvent.getActionCommand().equals(MAXIMIZE_WIDTH)) {
            this.maximizeWidthInSelectedRects();
            return;
        } else if (actionEvent.getActionCommand().equals(EXCLUDE_OTHER_PAGES)) {
            if (this.workingSet.getSourceFile() == null) {
                return;
            }
            this.setWorkingState(EXCLUDE_OTHER_PAGES);
            try {
                this.reloadWithOtherExcludes();
                this.setTitle("BRISS - " + this.workingSet.getSourceFile().getName());
                return;
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, iOException.getMessage(), "Error occured while reloading", 0);
                return;
            }
            catch (PdfException pdfException) {
                JOptionPane.showMessageDialog(this, pdfException.getMessage(), "Error occured while reloading", 0);
            }
            return;
        } else if (actionEvent.getActionCommand().equals(LOAD)) {
            File file = this.getNewFileToCrop();
            if (file == null) {
                return;
            }
            try {
                this.importNewPdfFile(file);
                this.setTitle("BRISS - " + file.getName());
                return;
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, iOException.getMessage(), "Error occured while loading", 0);
                return;
            }
            catch (PdfException pdfException) {
                JOptionPane.showMessageDialog(this, pdfException.getMessage(), "Error occured while loading", 0);
            }
            return;
        } else if (actionEvent.getActionCommand().equals(CROP)) {
            try {
                this.setWorkingState("loading PDF");
                File file = this.createAndExecuteCropJob(this.workingSet.getSourceFile());
                if (file == null) return;
                System.exit(0);
                return;
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, iOException.getMessage(), "Error occured while cropping", 0);
                return;
            }
            catch (DocumentException documentException) {
                JOptionPane.showMessageDialog(this, documentException.getMessage(), "Error occured while cropping", 0);
                return;
            }
            catch (CropException cropException) {
                JOptionPane.showMessageDialog(this, cropException.getMessage(), "Error occured while cropping", 0);
                return;
            }
            finally {
                this.setIdleState("");
            }
        } else if (actionEvent.getActionCommand().equals(PREVIEW)) {
            try {
                this.setWorkingState("Creating and showing preview...");
                File file = this.createAndExecuteCropJobForPreview();
                DesktopHelper.openFileWithDesktopApp(file);
                return;
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, iOException.getMessage(), "Error occured while cropping", 0);
                return;
            }
            catch (DocumentException documentException) {
                JOptionPane.showMessageDialog(this, documentException.getMessage(), "Error occured while cropping", 0);
                return;
            }
            catch (CropException cropException) {
                JOptionPane.showMessageDialog(this, cropException.getMessage(), "Error occured while cropping", 0);
                return;
            }
            finally {
                this.setIdleState("");
            }
        } else if (actionEvent.getActionCommand().equals(MAXIMIZE_ALL)) {
            for (MergedPanel mergedPanel : this.mergedPanels) {
                mergedPanel.selectCrops(true);
            }
            this.maximizeSizeInAllRects();
            return;
        } else if (actionEvent.getActionCommand().equals(MAXIMIZE_SIZE)) {
            this.maximizeSizeInAllRects();
            return;
        } else if (actionEvent.getActionCommand().equals(SET_SIZE)) {
            this.setDefinedSizeSelRects();
            return;
        } else if (actionEvent.getActionCommand().equals(SET_POSITION)) {
            this.setPositionSelRects();
            return;
        } else if (actionEvent.getActionCommand().equals(SELECT_ALL)) {
            for (MergedPanel mergedPanel : this.mergedPanels) {
                mergedPanel.selectCrops(true);
            }
            return;
        } else {
            if (!actionEvent.getActionCommand().equals(SELECT_NONE)) return;
            for (MergedPanel mergedPanel : this.mergedPanels) {
                mergedPanel.selectCrops(false);
            }
        }
    }

    private File createAndExecuteCropJobForPreview() throws IOException, DocumentException, CropException {
        File file = File.createTempFile("briss", ".pdf");
        CropDefinition cropDefinition = CropDefinition.createCropDefinition(this.workingSet.getSourceFile(), file, this.workingSet.getClusterDefinition());
        File file2 = DocumentCropper.crop(cropDefinition);
        return file2;
    }

    private File createAndExecuteCropJob(File file) throws IOException, DocumentException, CropException {
        File file2 = this.getCropFileDestination(this.workingSet.getSourceFile());
        if (file2 == null) {
            return null;
        }
        CropDefinition cropDefinition = CropDefinition.createCropDefinition(this.workingSet.getSourceFile(), file2, this.workingSet.getClusterDefinition());
        File file3 = DocumentCropper.crop(cropDefinition);
        return file3;
    }

    private void setIdleState(String string) {
        this.progressBar.setValue(0);
        this.progressBar.setString(string);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void setWorkingState(String string) {
        this.progressBar.setString(string);
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    void importNewPdfFile(File file) throws IOException, PdfException {
        this.lastOpenDir = file.getParentFile();
        this.previewPanel.removeAll();
        this.progressBar.setString("Loading new file - Creating merged previews");
        ClusterPagesTask clusterPagesTask = new ClusterPagesTask(file, BrissGUI.getExcludedPages());
        clusterPagesTask.addPropertyChangeListener(this);
        clusterPagesTask.execute();
    }

    private void reloadWithOtherExcludes() throws IOException, PdfException {
        this.previewPanel.removeAll();
        this.progressBar.setString("Reloading file - Creating merged previews");
        ClusterPagesTask clusterPagesTask = new ClusterPagesTask(this.workingSet.getSourceFile(), BrissGUI.getExcludedPages());
        clusterPagesTask.addPropertyChangeListener(this);
        clusterPagesTask.execute();
    }

    private void maximizeWidthInSelectedRects() {
        int n = -1;
        for (MergedPanel mergedPanel : this.mergedPanels) {
            int n2 = mergedPanel.getWidestSelectedRect();
            if (n >= n2) continue;
            n = n2;
        }
        if (n == -1) {
            return;
        }
        for (MergedPanel mergedPanel : this.mergedPanels) {
            mergedPanel.setSelCropWidth(n);
        }
    }

    private void maximizeHeightInSelectedRects() {
        int n = -1;
        for (MergedPanel mergedPanel : this.mergedPanels) {
            int n2 = mergedPanel.getHeighestSelectedRect();
            if (n >= n2) continue;
            n = n2;
        }
        if (n == -1) {
            return;
        }
        for (MergedPanel mergedPanel : this.mergedPanels) {
            mergedPanel.setSelCropHeight(n);
        }
    }

    private void maximizeSizeInAllRects() {
        int n = -1;
        int n2 = -1;
        for (MergedPanel mergedPanel : this.mergedPanels) {
            Dimension dimension = mergedPanel.getLargestRect();
            if (n < dimension.width) {
                n = dimension.width;
            }
            if (n2 >= dimension.height) continue;
            n2 = dimension.height;
        }
        if (n == -1 || n2 == -1) {
            return;
        }
        for (MergedPanel mergedPanel : this.mergedPanels) {
            mergedPanel.setAllCropSize(n, n2);
        }
    }

    public void alignSelRects(int n, int n2, int n3, int n4) {
        for (MergedPanel mergedPanel : this.mergedPanels) {
            mergedPanel.setSelCropSize(n3, n4);
            mergedPanel.moveToSelelectedCrops(n, n2);
        }
    }

    public void moveSelectedRects(int n, int n2) {
        for (MergedPanel mergedPanel : this.mergedPanels) {
            mergedPanel.moveSelelectedCrops(n, n2);
        }
    }

    public void setDefinedSizeSelRects() {
        int n;
        int n2;
        String[] stringArray;
        String string = "";
        int n3 = -1;
        int n4 = -1;
        Object object = this.mergedPanels.iterator();
        while (object.hasNext()) {
            stringArray = object.next();
            n2 = stringArray.getWidestSelectedRect();
            if (n3 < n2) {
                n3 = n2;
            }
            if (n4 >= (n = stringArray.getHeighestSelectedRect())) continue;
            n4 = n;
        }
        if (n3 >= 0 && n4 >= 0) {
            n3 = Math.round(25.4f * (float)n3 / 72.0f);
            n4 = Math.round(25.4f * (float)n4 / 72.0f);
            string = Integer.toString(n3) + " " + Integer.toString(n4);
        }
        if ((object = JOptionPane.showInputDialog(SET_SIZE_DESCRIPTION, (Object)string)) == null || ((String)object).equals("")) {
            return;
        }
        stringArray = ((String)object).split(" ", 2);
        if (stringArray.length != 2) {
            return;
        }
        n2 = -1;
        n = -1;
        try {
            n2 = Integer.parseInt(stringArray[0]);
            n = Integer.parseInt(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        n2 = Math.round((float)n2 * 72.0f / 25.4f);
        n = Math.round((float)n * 72.0f / 25.4f);
        for (MergedPanel mergedPanel : this.mergedPanels) {
            mergedPanel.setSelCropWidth(n2);
            mergedPanel.setSelCropHeight(n);
        }
    }

    public void setPositionSelRects() {
        int n;
        int n2;
        String[] stringArray;
        String string = "";
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MAX_VALUE;
        Object object = this.mergedPanels.iterator();
        while (object.hasNext()) {
            stringArray = object.next();
            n2 = stringArray.getLeftmostSelectedRect();
            if (n3 > n2) {
                n3 = n2;
            }
            if (n4 <= (n = stringArray.getUpmostSelectedRect())) continue;
            n4 = n;
        }
        if (n3 < Integer.MAX_VALUE && n4 < Integer.MAX_VALUE) {
            n3 = Math.round(25.4f * (float)n3 / 72.0f);
            n4 = Math.round(25.4f * (float)n4 / 72.0f);
            string = Integer.toString(n3) + " " + Integer.toString(n4);
        }
        if ((object = JOptionPane.showInputDialog(SET_POSITION_DESCRIPTION, (Object)string)) == null || ((String)object).equals("")) {
            return;
        }
        stringArray = ((String)object).split(" ", 2);
        if (stringArray.length != 2) {
            return;
        }
        n2 = -1;
        n = -1;
        try {
            n2 = Integer.parseInt(stringArray[0]);
            n = Integer.parseInt(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        n2 = Math.round((float)n2 * 72.0f / 25.4f);
        n = Math.round((float)n * 72.0f / 25.4f);
        for (MergedPanel mergedPanel : this.mergedPanels) {
            mergedPanel.moveToSelelectedCrops(n2, n);
        }
    }

    public void resizeSelRects(int n, int n2) {
        for (MergedPanel mergedPanel : this.mergedPanels) {
            mergedPanel.resizeSelCrop(n, n2);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("progress".equals(propertyChangeEvent.getPropertyName())) {
            this.progressBar.setValue((Integer)propertyChangeEvent.getNewValue());
        }
    }

    private void setStateAfterClusteringFinished(ClusterDefinition clusterDefinition, PageExcludes pageExcludes, File file) {
        this.updateWorkingSet(clusterDefinition, pageExcludes, file);
        this.previewPanel.removeAll();
        this.mergedPanels = new ArrayList<MergedPanel>();
        for (PageCluster pageCluster : this.workingSet.getClusterDefinition().getClusterList()) {
            MergedPanel mergedPanel = new MergedPanel(pageCluster, this);
            this.previewPanel.add(mergedPanel);
            this.mergedPanels.add(mergedPanel);
        }
        this.progressBar.setString("Clustering and Rendering finished");
        this.cropButton.setEnabled(true);
        this.maximizeWidthButton.setEnabled(true);
        this.maximizeHeightButton.setEnabled(true);
        this.excludePagesButton.setEnabled(true);
        this.showPreviewButton.setEnabled(true);
        this.maximizeSizeButton.setEnabled(true);
        this.maximizeAllButton.setEnabled(true);
        this.setSizeButton.setEnabled(true);
        this.setPositionButton.setEnabled(true);
        this.moveLeftButton.setEnabled(true);
        this.moveRightButton.setEnabled(true);
        this.moveUpButton.setEnabled(true);
        this.moveDownButton.setEnabled(true);
        this.selectAllButton.setEnabled(true);
        this.selectNoneButton.setEnabled(true);
        this.setIdleState("");
        this.pack();
        this.setExtendedState(6);
        this.previewPanel.repaint();
        this.repaint();
    }

    private void updateWorkingSet(ClusterDefinition clusterDefinition, PageExcludes pageExcludes, File file) {
        if (this.workingSet == null) {
            this.workingSet = new WorkingSet(file);
        } else if (this.workingSet.getSourceFile().equals(file)) {
            this.copyCropsToClusters(this.workingSet.getClusterDefinition(), clusterDefinition);
        }
        this.workingSet.setSourceFile(file);
        this.workingSet.setClusters(clusterDefinition);
        this.workingSet.setPageExcludes(pageExcludes);
    }

    private void copyCropsToClusters(ClusterDefinition clusterDefinition, ClusterDefinition clusterDefinition2) {
        for (PageCluster pageCluster : clusterDefinition2.getClusterList()) {
            for (Integer n : pageCluster.getAllPages()) {
                PageCluster pageCluster2 = clusterDefinition.getSingleCluster(n);
                for (Float[] floatArray : pageCluster2.getRatiosList()) {
                    pageCluster.addRatios(floatArray);
                }
            }
        }
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.previewPanel.revalidate();
        for (Component component : this.previewPanel.getComponents()) {
            component.repaint();
        }
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    private class ClusterPagesTask
    extends SwingWorker<Void, Void> {
        private final File source;
        private final PageExcludes pageExcludes;
        private ClusterDefinition clusterDefinition = null;

        public ClusterPagesTask(File file, PageExcludes pageExcludes) {
            this.source = file;
            this.pageExcludes = pageExcludes;
        }

        @Override
        protected void done() {
            BrissGUI.this.setStateAfterClusteringFinished(this.clusterDefinition, this.pageExcludes, this.source);
        }

        @Override
        protected Void doInBackground() {
            try {
                this.clusterDefinition = ClusterCreator.clusterPages(this.source, this.pageExcludes);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return null;
            }
            int n = this.clusterDefinition.getNrOfPagesToRender();
            ClusterRenderWorker clusterRenderWorker = new ClusterRenderWorker(this.source, this.clusterDefinition);
            clusterRenderWorker.start();
            while (clusterRenderWorker.isAlive()) {
                int n2 = (int)((float)clusterRenderWorker.workerUnitCounter / (float)n * 100.0f);
                this.setProgress(n2);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            return null;
        }
    }
}

