/*
 * Decompiled with CFR 0.152.
 */
package at.laborg.briss;

import at.laborg.briss.exception.CropException;
import at.laborg.briss.model.ClusterDefinition;
import at.laborg.briss.model.CropDefinition;
import at.laborg.briss.model.CropFinder;
import at.laborg.briss.model.PageCluster;
import at.laborg.briss.utils.BrissFileHandling;
import at.laborg.briss.utils.ClusterCreator;
import at.laborg.briss.utils.ClusterRenderWorker;
import at.laborg.briss.utils.DocumentCropper;
import com.itextpdf.text.DocumentException;
import java.io.File;
import java.io.IOException;

public final class BrissCMD {
    private BrissCMD() {
    }

    public static void autoCrop(String[] stringArray) {
        CommandValues commandValues = CommandValues.parseToWorkDescription(stringArray);
        if (!CommandValues.isValidJob(commandValues)) {
            return;
        }
        System.out.println("Clustering PDF: " + commandValues.getSourceFile());
        ClusterDefinition clusterDefinition = null;
        try {
            clusterDefinition = ClusterCreator.clusterPages(commandValues.getSourceFile(), null);
        }
        catch (IOException iOException) {
            System.out.println("Error occured while clustering.");
            iOException.printStackTrace(System.out);
            return;
        }
        System.out.println("Created " + clusterDefinition.getClusterList().size() + " clusters.");
        ClusterRenderWorker clusterRenderWorker = new ClusterRenderWorker(commandValues.getSourceFile(), clusterDefinition);
        clusterRenderWorker.start();
        System.out.print("Starting to render clusters.");
        while (clusterRenderWorker.isAlive()) {
            System.out.print(".");
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        System.out.println("finished!");
        System.out.println("Calculating crop rectangles.");
        try {
            for (PageCluster pageCluster : clusterDefinition.getClusterList()) {
                Float[] floatArray = CropFinder.getAutoCropFloats(pageCluster.getImageData().getPreviewImage());
                pageCluster.addRatios(floatArray);
            }
            CropDefinition cropDefinition = CropDefinition.createCropDefinition(commandValues.getSourceFile(), commandValues.getDestFile(), clusterDefinition);
            System.out.println("Starting to crop files.");
            DocumentCropper.crop(cropDefinition);
            System.out.println("Cropping succesful. Cropped to:" + commandValues.getDestFile().getAbsolutePath());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (DocumentException documentException) {
            documentException.printStackTrace();
        }
        catch (CropException cropException) {
            System.out.println("Error while cropping:" + cropException.getMessage());
        }
    }

    private static class CommandValues {
        private static final String SOURCE_FILE_CMD = "-s";
        private static final String DEST_FILE_CMD = "-d";
        private File sourceFile;
        private File destFile;

        private CommandValues() {
        }

        static CommandValues parseToWorkDescription(String[] stringArray) {
            CommandValues commandValues = new CommandValues();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].trim().equalsIgnoreCase(SOURCE_FILE_CMD)) {
                    if (i >= stringArray.length - 1) continue;
                    commandValues.setSourceFile(new File(stringArray[i + 1]));
                    continue;
                }
                if (!stringArray[i].trim().equalsIgnoreCase(DEST_FILE_CMD) || i >= stringArray.length - 1) continue;
                commandValues.setDestFile(new File(stringArray[i + 1]));
            }
            return commandValues;
        }

        private static boolean isValidJob(CommandValues commandValues) {
            if (commandValues.getSourceFile() == null) {
                System.out.println("No source file submitted: try \"java -jar Briss.0.0.13 -s filename.pdf\"");
                return false;
            }
            if (!commandValues.getSourceFile().exists()) {
                System.out.println("File: " + commandValues.getSourceFile() + " doesn't exist");
                return false;
            }
            if (commandValues.getDestFile() == null) {
                File file = BrissFileHandling.getRecommendedDestination(commandValues.getSourceFile());
                commandValues.setDestFile(file);
                System.out.println("Since no destination was provided destination will be set to  : " + file.getAbsolutePath());
            }
            try {
                BrissFileHandling.checkValidStateAndCreate(commandValues.getDestFile());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.out.println("Destination file couldn't be created!");
                return false;
            }
            catch (IOException iOException) {
                System.out.println("IO Error while creating destination file.");
                iOException.getStackTrace();
                return false;
            }
            return true;
        }

        public File getSourceFile() {
            return this.sourceFile;
        }

        public void setSourceFile(File file) {
            this.sourceFile = file;
        }

        public File getDestFile() {
            return this.destFile;
        }

        public void setDestFile(File file) {
            this.destFile = file;
        }
    }
}

